package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsListInvoiceMain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询发票list返回对象数组
 */
@ApiModel(description = "查询发票list返回对象数组")

@JsonInclude(NON_NULL)
public class MsListInvoiceModel {
  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("invoiceMains")
  private List<MsListInvoiceMain> invoiceMains = new ArrayList<MsListInvoiceMain>();

  @JsonIgnore
  public MsListInvoiceModel total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 总数量
   * @return total
  **/
  @ApiModelProperty(value = "总数量")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsListInvoiceModel invoiceMains(List<MsListInvoiceMain> invoiceMains) {
    this.invoiceMains = invoiceMains;
    return this;
  }

  public MsListInvoiceModel addInvoiceMainsItem(MsListInvoiceMain invoiceMainsItem) {
    this.invoiceMains.add(invoiceMainsItem);
    return this;
  }

   /**
   * 查询发票list返回对象
   * @return invoiceMains
  **/
  @ApiModelProperty(value = "查询发票list返回对象")
  public List<MsListInvoiceMain> getInvoiceMains() {
    return invoiceMains;
  }

  public void setInvoiceMains(List<MsListInvoiceMain> invoiceMains) {
    this.invoiceMains = invoiceMains;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListInvoiceModel listInvoiceModel = (MsListInvoiceModel) o;
    return Objects.equals(this.total, listInvoiceModel.total) &&
        Objects.equals(this.invoiceMains, listInvoiceModel.invoiceMains);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, invoiceMains);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListInvoiceModel {\n");
    
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    invoiceMains: ").append(toIndentedString(invoiceMains)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
