package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsInvoiceVerifyMain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 批量发票查验请求
 */
@ApiModel(description = "批量发票查验请求")

@JsonInclude(NON_NULL)
public class MsBatchVerifyRequest {
  @JsonProperty("invoiceVerifyMains")
  private List<MsInvoiceVerifyMain> invoiceVerifyMains = new ArrayList<MsInvoiceVerifyMain>();

  @JsonProperty("verifyOrig")
  private Integer verifyOrig = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("operatorName")
  private String operatorName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonIgnore
  public MsBatchVerifyRequest invoiceVerifyMains(List<MsInvoiceVerifyMain> invoiceVerifyMains) {
    this.invoiceVerifyMains = invoiceVerifyMains;
    return this;
  }

  public MsBatchVerifyRequest addInvoiceVerifyMainsItem(MsInvoiceVerifyMain invoiceVerifyMainsItem) {
    this.invoiceVerifyMains.add(invoiceVerifyMainsItem);
    return this;
  }

   /**
   * 发票查验请求4要素数组
   * @return invoiceVerifyMains
  **/
  @ApiModelProperty(value = "发票查验请求4要素数组")
  public List<MsInvoiceVerifyMain> getInvoiceVerifyMains() {
    return invoiceVerifyMains;
  }

  public void setInvoiceVerifyMains(List<MsInvoiceVerifyMain> invoiceVerifyMains) {
    this.invoiceVerifyMains = invoiceVerifyMains;
  }

  @JsonIgnore
  public MsBatchVerifyRequest verifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
    return this;
  }

   /**
   * 查验请求来源
   * @return verifyOrig
  **/
  @ApiModelProperty(value = "查验请求来源")
  public Integer getVerifyOrig() {
    return verifyOrig;
  }

  public void setVerifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
  }

  @JsonIgnore
  public MsBatchVerifyRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsBatchVerifyRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsBatchVerifyRequest operatorName(String operatorName) {
    this.operatorName = operatorName;
    return this;
  }

   /**
   * 操作者姓名
   * @return operatorName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getOperatorName() {
    return operatorName;
  }

  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  @JsonIgnore
  public MsBatchVerifyRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchVerifyRequest batchVerifyRequest = (MsBatchVerifyRequest) o;
    return Objects.equals(this.invoiceVerifyMains, batchVerifyRequest.invoiceVerifyMains) &&
        Objects.equals(this.verifyOrig, batchVerifyRequest.verifyOrig) &&
        Objects.equals(this.purchaserTaxNo, batchVerifyRequest.purchaserTaxNo) &&
        Objects.equals(this.operatorId, batchVerifyRequest.operatorId) &&
        Objects.equals(this.operatorName, batchVerifyRequest.operatorName) &&
        Objects.equals(this.groupId, batchVerifyRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceVerifyMains, verifyOrig, purchaserTaxNo, operatorId, operatorName, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchVerifyRequest {\n");
    
    sb.append("    invoiceVerifyMains: ").append(toIndentedString(invoiceVerifyMains)).append("\n");
    sb.append("    verifyOrig: ").append(toIndentedString(verifyOrig)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    operatorName: ").append(toIndentedString(operatorName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
