package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsRequestField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询条件
 */
@ApiModel(description = "查询条件")

@JsonInclude(NON_NULL)
public class MsFiltersConditionRequest {
  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("filters")
  private List<MsRequestField> filters = new ArrayList<MsRequestField>();

  @JsonIgnore
  public MsFiltersConditionRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsFiltersConditionRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页显示数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页显示数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsFiltersConditionRequest filters(List<MsRequestField> filters) {
    this.filters = filters;
    return this;
  }

  public MsFiltersConditionRequest addFiltersItem(MsRequestField filtersItem) {
    this.filters.add(filtersItem);
    return this;
  }

   /**
   * 查询条件列表
   * @return filters
  **/
  @ApiModelProperty(value = "查询条件列表")
  public List<MsRequestField> getFilters() {
    return filters;
  }

  public void setFilters(List<MsRequestField> filters) {
    this.filters = filters;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFiltersConditionRequest filtersConditionRequest = (MsFiltersConditionRequest) o;
    return Objects.equals(this.pageNo, filtersConditionRequest.pageNo) &&
        Objects.equals(this.pageSize, filtersConditionRequest.pageSize) &&
        Objects.equals(this.filters, filtersConditionRequest.filters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageNo, pageSize, filters);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFiltersConditionRequest {\n");
    
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
