package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsInvoiceDetail;
import com.xforceplus.phoenix.verify.client.model.MsInvoiceMain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查验明细对象
 */
@ApiModel(description = "查验明细对象")

@JsonInclude(NON_NULL)
public class MsInvoiceDetails {
  @JsonProperty("invoiceMain")
  private MsInvoiceMain invoiceMain = null;

  @JsonProperty("invoiceDetails")
  private List<MsInvoiceDetail> invoiceDetails = new ArrayList<MsInvoiceDetail>();

  @JsonIgnore
  public MsInvoiceDetails invoiceMain(MsInvoiceMain invoiceMain) {
    this.invoiceMain = invoiceMain;
    return this;
  }

   /**
   * 发票主信息
   * @return invoiceMain
  **/
  @ApiModelProperty(value = "发票主信息")
  public MsInvoiceMain getInvoiceMain() {
    return invoiceMain;
  }

  public void setInvoiceMain(MsInvoiceMain invoiceMain) {
    this.invoiceMain = invoiceMain;
  }

  @JsonIgnore
  public MsInvoiceDetails invoiceDetails(List<MsInvoiceDetail> invoiceDetails) {
    this.invoiceDetails = invoiceDetails;
    return this;
  }

  public MsInvoiceDetails addInvoiceDetailsItem(MsInvoiceDetail invoiceDetailsItem) {
    this.invoiceDetails.add(invoiceDetailsItem);
    return this;
  }

   /**
   * 发票明细信息
   * @return invoiceDetails
  **/
  @ApiModelProperty(value = "发票明细信息")
  public List<MsInvoiceDetail> getInvoiceDetails() {
    return invoiceDetails;
  }

  public void setInvoiceDetails(List<MsInvoiceDetail> invoiceDetails) {
    this.invoiceDetails = invoiceDetails;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceDetails invoiceDetails = (MsInvoiceDetails) o;
    return Objects.equals(this.invoiceMain, invoiceDetails.invoiceMain) &&
        Objects.equals(this.invoiceDetails, invoiceDetails.invoiceDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceMain, invoiceDetails);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceDetails {\n");
    
    sb.append("    invoiceMain: ").append(toIndentedString(invoiceMain)).append("\n");
    sb.append("    invoiceDetails: ").append(toIndentedString(invoiceDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
