package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票主信息
 */
@ApiModel(description = "发票主信息")

@JsonInclude(NON_NULL)
public class MsInvoiceMain {
  @JsonProperty("taskId")
  private String taskId = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("sellerId")
  private String sellerId = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddrTel")
  private String sellerAddrTel = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("sellerBankNameAccount")
  private String sellerBankNameAccount = null;

  @JsonProperty("sellerBankInfo")
  private String sellerBankInfo = null;

  @JsonProperty("purchaserId")
  private String purchaserId = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddrTel")
  private String purchaserAddrTel = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserBankNameAccount")
  private String purchaserBankNameAccount = null;

  @JsonProperty("purchaserBankInfo")
  private String purchaserBankInfo = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("provinceCode")
  private Integer provinceCode = null;

  @JsonProperty("provinceName")
  private String provinceName = null;

  @JsonProperty("specialInvoiceFlag")
  private Integer specialInvoiceFlag = null;

  @JsonProperty("cpyStatus")
  private String cpyStatus = null;

  @JsonProperty("ctStatus")
  private String ctStatus = null;

  @JsonProperty("dqCode")
  private String dqCode = null;

  @JsonProperty("dqName")
  private String dqName = null;

  @JsonProperty("checkTime")
  private String checkTime = null;

  @JsonProperty("checkNumber")
  private String checkNumber = null;

  @JsonProperty("saleListFlag")
  private String saleListFlag = null;

  @JsonProperty("goodsListFlag")
  private String goodsListFlag = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("receivingClerk")
  private String receivingClerk = null;

  @JsonProperty("organizationCode")
  private String organizationCode = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonProperty("vehicleBrand")
  private String vehicleBrand = null;

  @JsonProperty("productionArea")
  private String productionArea = null;

  @JsonProperty("certNo")
  private String certNo = null;

  @JsonProperty("certificationNo")
  private String certificationNo = null;

  @JsonProperty("importCertNo")
  private String importCertNo = null;

  @JsonProperty("importCertificateNo")
  private String importCertificateNo = null;

  @JsonProperty("inspectionNo")
  private String inspectionNo = null;

  @JsonProperty("commodityInspectionNo")
  private String commodityInspectionNo = null;

  @JsonProperty("engineNo")
  private String engineNo = null;

  @JsonProperty("vin")
  private String vin = null;

  @JsonProperty("vehicleNo")
  private String vehicleNo = null;

  @JsonProperty("tonnage")
  private String tonnage = null;

  @JsonProperty("taxPaidProof")
  private String taxPaidProof = null;

  @JsonProperty("maxCapacity")
  private String maxCapacity = null;

  @JsonProperty("taxAuthCode")
  private String taxAuthCode = null;

  @JsonProperty("taxAuthName")
  private String taxAuthName = null;

  @JsonProperty("chargeTaxAuthorityCode")
  private String chargeTaxAuthorityCode = null;

  @JsonProperty("chargeTaxAuthorityName")
  private String chargeTaxAuthorityName = null;

  @JsonIgnore
  public MsInvoiceMain taskId(String taskId) {
    this.taskId = taskId;
    return this;
  }

   /**
   * 发票代码
   * @return taskId
  **/
  @ApiModelProperty(value = "发票代码")
  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsInvoiceMain paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 发票开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsInvoiceMain checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public MsInvoiceMain amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsInvoiceMain sellerId(String sellerId) {
    this.sellerId = sellerId;
    return this;
  }

   /**
   * 销方公司ID
   * @return sellerId
  **/
  @ApiModelProperty(value = "销方公司ID")
  public String getSellerId() {
    return sellerId;
  }

  public void setSellerId(String sellerId) {
    this.sellerId = sellerId;
  }

  @JsonIgnore
  public MsInvoiceMain sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsInvoiceMain sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsInvoiceMain sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public MsInvoiceMain sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public MsInvoiceMain sellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
    return this;
  }

   /**
   * 销方地址电话
   * @return sellerAddrTel
  **/
  @ApiModelProperty(value = "销方地址电话")
  public String getSellerAddrTel() {
    return sellerAddrTel;
  }

  public void setSellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
  }

  @JsonIgnore
  public MsInvoiceMain sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public MsInvoiceMain sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行账号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public MsInvoiceMain sellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
    return this;
  }

   /**
   * 销方开户行及账号
   * @return sellerBankNameAccount
  **/
  @ApiModelProperty(value = "销方开户行及账号")
  public String getSellerBankNameAccount() {
    return sellerBankNameAccount;
  }

  public void setSellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
  }

  @JsonIgnore
  public MsInvoiceMain sellerBankInfo(String sellerBankInfo) {
    this.sellerBankInfo = sellerBankInfo;
    return this;
  }

   /**
   * 销方开户行及账号
   * @return sellerBankInfo
  **/
  @ApiModelProperty(value = "销方开户行及账号")
  public String getSellerBankInfo() {
    return sellerBankInfo;
  }

  public void setSellerBankInfo(String sellerBankInfo) {
    this.sellerBankInfo = sellerBankInfo;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserId(String purchaserId) {
    this.purchaserId = purchaserId;
    return this;
  }

   /**
   * 购方公司ID
   * @return purchaserId
  **/
  @ApiModelProperty(value = "购方公司ID")
  public String getPurchaserId() {
    return purchaserId;
  }

  public void setPurchaserId(String purchaserId) {
    this.purchaserId = purchaserId;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
    return this;
  }

   /**
   * 购方地址.电话
   * @return purchaserAddrTel
  **/
  @ApiModelProperty(value = "购方地址.电话")
  public String getPurchaserAddrTel() {
    return purchaserAddrTel;
  }

  public void setPurchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行账号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
    return this;
  }

   /**
   * 购方开户行及账号
   * @return purchaserBankNameAccount
  **/
  @ApiModelProperty(value = "购方开户行及账号")
  public String getPurchaserBankNameAccount() {
    return purchaserBankNameAccount;
  }

  public void setPurchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserBankInfo(String purchaserBankInfo) {
    this.purchaserBankInfo = purchaserBankInfo;
    return this;
  }

   /**
   * 购方开户行及账号
   * @return purchaserBankInfo
  **/
  @ApiModelProperty(value = "购方开户行及账号")
  public String getPurchaserBankInfo() {
    return purchaserBankInfo;
  }

  public void setPurchaserBankInfo(String purchaserBankInfo) {
    this.purchaserBankInfo = purchaserBankInfo;
  }

  @JsonIgnore
  public MsInvoiceMain taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsInvoiceMain taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsInvoiceMain amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsInvoiceMain machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public MsInvoiceMain cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public MsInvoiceMain remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型: 增值税专用发票 s 增值税普通发票 c 增值税电子普通发票 ce 增值税普通发票（卷票） ju 通行费增值税电子普通发票 ct 机动车统一销售发票 v 
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型: 增值税专用发票 s 增值税普通发票 c 增值税电子普通发票 ce 增值税普通发票（卷票） ju 通行费增值税电子普通发票 ct 机动车统一销售发票 v ")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsInvoiceMain status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态0-默认；1-正常；2-红冲；3-作废
   * @return status
  **/
  @ApiModelProperty(value = "状态0-默认；1-正常；2-红冲；3-作废")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsInvoiceMain provinceCode(Integer provinceCode) {
    this.provinceCode = provinceCode;
    return this;
  }

   /**
   * 发票地区代码
   * @return provinceCode
  **/
  @ApiModelProperty(value = "发票地区代码")
  public Integer getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(Integer provinceCode) {
    this.provinceCode = provinceCode;
  }

  @JsonIgnore
  public MsInvoiceMain provinceName(String provinceName) {
    this.provinceName = provinceName;
    return this;
  }

   /**
   * 发票地区
   * @return provinceName
  **/
  @ApiModelProperty(value = "发票地区")
  public String getProvinceName() {
    return provinceName;
  }

  public void setProvinceName(String provinceName) {
    this.provinceName = provinceName;
  }

  @JsonIgnore
  public MsInvoiceMain specialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
    return this;
  }

   /**
   * 特殊发票标志 0-非特殊发票；1-通行费；2-成品油
   * @return specialInvoiceFlag
  **/
  @ApiModelProperty(value = "特殊发票标志 0-非特殊发票；1-通行费；2-成品油")
  public Integer getSpecialInvoiceFlag() {
    return specialInvoiceFlag;
  }

  public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
  }

  @JsonIgnore
  public MsInvoiceMain cpyStatus(String cpyStatus) {
    this.cpyStatus = cpyStatus;
    return this;
  }

   /**
   * 特殊发票标志0-非特殊发票；1-成品油
   * @return cpyStatus
  **/
  @ApiModelProperty(value = "特殊发票标志0-非特殊发票；1-成品油")
  public String getCpyStatus() {
    return cpyStatus;
  }

  public void setCpyStatus(String cpyStatus) {
    this.cpyStatus = cpyStatus;
  }

  @JsonIgnore
  public MsInvoiceMain ctStatus(String ctStatus) {
    this.ctStatus = ctStatus;
    return this;
  }

   /**
   * 特殊发票标志 0-非特殊发票；1-通行费
   * @return ctStatus
  **/
  @ApiModelProperty(value = "特殊发票标志 0-非特殊发票；1-通行费")
  public String getCtStatus() {
    return ctStatus;
  }

  public void setCtStatus(String ctStatus) {
    this.ctStatus = ctStatus;
  }

  @JsonIgnore
  public MsInvoiceMain dqCode(String dqCode) {
    this.dqCode = dqCode;
    return this;
  }

   /**
   * 发票所属省份代码
   * @return dqCode
  **/
  @ApiModelProperty(value = "发票所属省份代码")
  public String getDqCode() {
    return dqCode;
  }

  public void setDqCode(String dqCode) {
    this.dqCode = dqCode;
  }

  @JsonIgnore
  public MsInvoiceMain dqName(String dqName) {
    this.dqName = dqName;
    return this;
  }

   /**
   * 发票所属省份名
   * @return dqName
  **/
  @ApiModelProperty(value = "发票所属省份名")
  public String getDqName() {
    return dqName;
  }

  public void setDqName(String dqName) {
    this.dqName = dqName;
  }

  @JsonIgnore
  public MsInvoiceMain checkTime(String checkTime) {
    this.checkTime = checkTime;
    return this;
  }

   /**
   * 查验时间
   * @return checkTime
  **/
  @ApiModelProperty(value = "查验时间")
  public String getCheckTime() {
    return checkTime;
  }

  public void setCheckTime(String checkTime) {
    this.checkTime = checkTime;
  }

  @JsonIgnore
  public MsInvoiceMain checkNumber(String checkNumber) {
    this.checkNumber = checkNumber;
    return this;
  }

   /**
   * 查验次数
   * @return checkNumber
  **/
  @ApiModelProperty(value = "查验次数")
  public String getCheckNumber() {
    return checkNumber;
  }

  public void setCheckNumber(String checkNumber) {
    this.checkNumber = checkNumber;
  }

  @JsonIgnore
  public MsInvoiceMain saleListFlag(String saleListFlag) {
    this.saleListFlag = saleListFlag;
    return this;
  }

   /**
   * 是否有销货清单0否1是
   * @return saleListFlag
  **/
  @ApiModelProperty(value = "是否有销货清单0否1是")
  public String getSaleListFlag() {
    return saleListFlag;
  }

  public void setSaleListFlag(String saleListFlag) {
    this.saleListFlag = saleListFlag;
  }

  @JsonIgnore
  public MsInvoiceMain goodsListFlag(String goodsListFlag) {
    this.goodsListFlag = goodsListFlag;
    return this;
  }

   /**
   * 是否有销货清单0否1是
   * @return goodsListFlag
  **/
  @ApiModelProperty(value = "是否有销货清单0否1是")
  public String getGoodsListFlag() {
    return goodsListFlag;
  }

  public void setGoodsListFlag(String goodsListFlag) {
    this.goodsListFlag = goodsListFlag;
  }

  @JsonIgnore
  public MsInvoiceMain cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public MsInvoiceMain checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public MsInvoiceMain invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public MsInvoiceMain receivingClerk(String receivingClerk) {
    this.receivingClerk = receivingClerk;
    return this;
  }

   /**
   * 卷票-收货员
   * @return receivingClerk
  **/
  @ApiModelProperty(value = "卷票-收货员")
  public String getReceivingClerk() {
    return receivingClerk;
  }

  public void setReceivingClerk(String receivingClerk) {
    this.receivingClerk = receivingClerk;
  }

  @JsonIgnore
  public MsInvoiceMain organizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
    return this;
  }

   /**
   * 身份证号码/组织机构码
   * @return organizationCode
  **/
  @ApiModelProperty(value = "身份证号码/组织机构码")
  public String getOrganizationCode() {
    return organizationCode;
  }

  public void setOrganizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
  }

  @JsonIgnore
  public MsInvoiceMain vehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }

  @JsonIgnore
  public MsInvoiceMain vehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
    return this;
  }

   /**
   * 厂牌型号
   * @return vehicleBrand
  **/
  @ApiModelProperty(value = "厂牌型号")
  public String getVehicleBrand() {
    return vehicleBrand;
  }

  public void setVehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
  }

  @JsonIgnore
  public MsInvoiceMain productionArea(String productionArea) {
    this.productionArea = productionArea;
    return this;
  }

   /**
   * 产地
   * @return productionArea
  **/
  @ApiModelProperty(value = "产地")
  public String getProductionArea() {
    return productionArea;
  }

  public void setProductionArea(String productionArea) {
    this.productionArea = productionArea;
  }

  @JsonIgnore
  public MsInvoiceMain certNo(String certNo) {
    this.certNo = certNo;
    return this;
  }

   /**
   * 合格证号
   * @return certNo
  **/
  @ApiModelProperty(value = "合格证号")
  public String getCertNo() {
    return certNo;
  }

  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  @JsonIgnore
  public MsInvoiceMain certificationNo(String certificationNo) {
    this.certificationNo = certificationNo;
    return this;
  }

   /**
   * 合格证号
   * @return certificationNo
  **/
  @ApiModelProperty(value = "合格证号")
  public String getCertificationNo() {
    return certificationNo;
  }

  public void setCertificationNo(String certificationNo) {
    this.certificationNo = certificationNo;
  }

  @JsonIgnore
  public MsInvoiceMain importCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
    return this;
  }

   /**
   * 进口证明书编号
   * @return importCertNo
  **/
  @ApiModelProperty(value = "进口证明书编号")
  public String getImportCertNo() {
    return importCertNo;
  }

  public void setImportCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
  }

  @JsonIgnore
  public MsInvoiceMain importCertificateNo(String importCertificateNo) {
    this.importCertificateNo = importCertificateNo;
    return this;
  }

   /**
   * 进口证明书编号
   * @return importCertificateNo
  **/
  @ApiModelProperty(value = "进口证明书编号")
  public String getImportCertificateNo() {
    return importCertificateNo;
  }

  public void setImportCertificateNo(String importCertificateNo) {
    this.importCertificateNo = importCertificateNo;
  }

  @JsonIgnore
  public MsInvoiceMain inspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
    return this;
  }

   /**
   * 商检单号
   * @return inspectionNo
  **/
  @ApiModelProperty(value = "商检单号")
  public String getInspectionNo() {
    return inspectionNo;
  }

  public void setInspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
  }

  @JsonIgnore
  public MsInvoiceMain commodityInspectionNo(String commodityInspectionNo) {
    this.commodityInspectionNo = commodityInspectionNo;
    return this;
  }

   /**
   * 商检单号
   * @return commodityInspectionNo
  **/
  @ApiModelProperty(value = "商检单号")
  public String getCommodityInspectionNo() {
    return commodityInspectionNo;
  }

  public void setCommodityInspectionNo(String commodityInspectionNo) {
    this.commodityInspectionNo = commodityInspectionNo;
  }

  @JsonIgnore
  public MsInvoiceMain engineNo(String engineNo) {
    this.engineNo = engineNo;
    return this;
  }

   /**
   * 发动机号码
   * @return engineNo
  **/
  @ApiModelProperty(value = "发动机号码")
  public String getEngineNo() {
    return engineNo;
  }

  public void setEngineNo(String engineNo) {
    this.engineNo = engineNo;
  }

  @JsonIgnore
  public MsInvoiceMain vin(String vin) {
    this.vin = vin;
    return this;
  }

   /**
   * 车辆识别代号/车架号码
   * @return vin
  **/
  @ApiModelProperty(value = "车辆识别代号/车架号码")
  public String getVin() {
    return vin;
  }

  public void setVin(String vin) {
    this.vin = vin;
  }

  @JsonIgnore
  public MsInvoiceMain vehicleNo(String vehicleNo) {
    this.vehicleNo = vehicleNo;
    return this;
  }

   /**
   * 车辆识别代号/车架号码
   * @return vehicleNo
  **/
  @ApiModelProperty(value = "车辆识别代号/车架号码")
  public String getVehicleNo() {
    return vehicleNo;
  }

  public void setVehicleNo(String vehicleNo) {
    this.vehicleNo = vehicleNo;
  }

  @JsonIgnore
  public MsInvoiceMain tonnage(String tonnage) {
    this.tonnage = tonnage;
    return this;
  }

   /**
   * 吨位
   * @return tonnage
  **/
  @ApiModelProperty(value = "吨位")
  public String getTonnage() {
    return tonnage;
  }

  public void setTonnage(String tonnage) {
    this.tonnage = tonnage;
  }

  @JsonIgnore
  public MsInvoiceMain taxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
    return this;
  }

   /**
   * 完税凭证号
   * @return taxPaidProof
  **/
  @ApiModelProperty(value = "完税凭证号")
  public String getTaxPaidProof() {
    return taxPaidProof;
  }

  public void setTaxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
  }

  @JsonIgnore
  public MsInvoiceMain maxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
    return this;
  }

   /**
   * 限乘人数
   * @return maxCapacity
  **/
  @ApiModelProperty(value = "限乘人数")
  public String getMaxCapacity() {
    return maxCapacity;
  }

  public void setMaxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
  }

  @JsonIgnore
  public MsInvoiceMain taxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
    return this;
  }

   /**
   * 主管税务机关代码
   * @return taxAuthCode
  **/
  @ApiModelProperty(value = "主管税务机关代码")
  public String getTaxAuthCode() {
    return taxAuthCode;
  }

  public void setTaxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
  }

  @JsonIgnore
  public MsInvoiceMain taxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
    return this;
  }

   /**
   * 主管税务机关名称
   * @return taxAuthName
  **/
  @ApiModelProperty(value = "主管税务机关名称")
  public String getTaxAuthName() {
    return taxAuthName;
  }

  public void setTaxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
  }

  @JsonIgnore
  public MsInvoiceMain chargeTaxAuthorityCode(String chargeTaxAuthorityCode) {
    this.chargeTaxAuthorityCode = chargeTaxAuthorityCode;
    return this;
  }

   /**
   * 主管税务机关代码
   * @return chargeTaxAuthorityCode
  **/
  @ApiModelProperty(value = "主管税务机关代码")
  public String getChargeTaxAuthorityCode() {
    return chargeTaxAuthorityCode;
  }

  public void setChargeTaxAuthorityCode(String chargeTaxAuthorityCode) {
    this.chargeTaxAuthorityCode = chargeTaxAuthorityCode;
  }

  @JsonIgnore
  public MsInvoiceMain chargeTaxAuthorityName(String chargeTaxAuthorityName) {
    this.chargeTaxAuthorityName = chargeTaxAuthorityName;
    return this;
  }

   /**
   * 主管税务机关名称
   * @return chargeTaxAuthorityName
  **/
  @ApiModelProperty(value = "主管税务机关名称")
  public String getChargeTaxAuthorityName() {
    return chargeTaxAuthorityName;
  }

  public void setChargeTaxAuthorityName(String chargeTaxAuthorityName) {
    this.chargeTaxAuthorityName = chargeTaxAuthorityName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceMain invoiceMain = (MsInvoiceMain) o;
    return Objects.equals(this.taskId, invoiceMain.taskId) &&
        Objects.equals(this.invoiceCode, invoiceMain.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoiceMain.invoiceNo) &&
        Objects.equals(this.paperDrewDate, invoiceMain.paperDrewDate) &&
        Objects.equals(this.checkCode, invoiceMain.checkCode) &&
        Objects.equals(this.amountWithoutTax, invoiceMain.amountWithoutTax) &&
        Objects.equals(this.sellerId, invoiceMain.sellerId) &&
        Objects.equals(this.sellerTaxNo, invoiceMain.sellerTaxNo) &&
        Objects.equals(this.sellerName, invoiceMain.sellerName) &&
        Objects.equals(this.sellerAddress, invoiceMain.sellerAddress) &&
        Objects.equals(this.sellerTel, invoiceMain.sellerTel) &&
        Objects.equals(this.sellerAddrTel, invoiceMain.sellerAddrTel) &&
        Objects.equals(this.sellerBankName, invoiceMain.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, invoiceMain.sellerBankAccount) &&
        Objects.equals(this.sellerBankNameAccount, invoiceMain.sellerBankNameAccount) &&
        Objects.equals(this.sellerBankInfo, invoiceMain.sellerBankInfo) &&
        Objects.equals(this.purchaserId, invoiceMain.purchaserId) &&
        Objects.equals(this.purchaserTaxNo, invoiceMain.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, invoiceMain.purchaserName) &&
        Objects.equals(this.purchaserAddress, invoiceMain.purchaserAddress) &&
        Objects.equals(this.purchaserTel, invoiceMain.purchaserTel) &&
        Objects.equals(this.purchaserAddrTel, invoiceMain.purchaserAddrTel) &&
        Objects.equals(this.purchaserBankName, invoiceMain.purchaserBankName) &&
        Objects.equals(this.purchaserBankAccount, invoiceMain.purchaserBankAccount) &&
        Objects.equals(this.purchaserBankNameAccount, invoiceMain.purchaserBankNameAccount) &&
        Objects.equals(this.purchaserBankInfo, invoiceMain.purchaserBankInfo) &&
        Objects.equals(this.taxRate, invoiceMain.taxRate) &&
        Objects.equals(this.taxAmount, invoiceMain.taxAmount) &&
        Objects.equals(this.amountWithTax, invoiceMain.amountWithTax) &&
        Objects.equals(this.machineCode, invoiceMain.machineCode) &&
        Objects.equals(this.cipherText, invoiceMain.cipherText) &&
        Objects.equals(this.remark, invoiceMain.remark) &&
        Objects.equals(this.invoiceType, invoiceMain.invoiceType) &&
        Objects.equals(this.status, invoiceMain.status) &&
        Objects.equals(this.provinceCode, invoiceMain.provinceCode) &&
        Objects.equals(this.provinceName, invoiceMain.provinceName) &&
        Objects.equals(this.specialInvoiceFlag, invoiceMain.specialInvoiceFlag) &&
        Objects.equals(this.cpyStatus, invoiceMain.cpyStatus) &&
        Objects.equals(this.ctStatus, invoiceMain.ctStatus) &&
        Objects.equals(this.dqCode, invoiceMain.dqCode) &&
        Objects.equals(this.dqName, invoiceMain.dqName) &&
        Objects.equals(this.checkTime, invoiceMain.checkTime) &&
        Objects.equals(this.checkNumber, invoiceMain.checkNumber) &&
        Objects.equals(this.saleListFlag, invoiceMain.saleListFlag) &&
        Objects.equals(this.goodsListFlag, invoiceMain.goodsListFlag) &&
        Objects.equals(this.cashierName, invoiceMain.cashierName) &&
        Objects.equals(this.checkerName, invoiceMain.checkerName) &&
        Objects.equals(this.invoicerName, invoiceMain.invoicerName) &&
        Objects.equals(this.receivingClerk, invoiceMain.receivingClerk) &&
        Objects.equals(this.organizationCode, invoiceMain.organizationCode) &&
        Objects.equals(this.vehicleType, invoiceMain.vehicleType) &&
        Objects.equals(this.vehicleBrand, invoiceMain.vehicleBrand) &&
        Objects.equals(this.productionArea, invoiceMain.productionArea) &&
        Objects.equals(this.certNo, invoiceMain.certNo) &&
        Objects.equals(this.certificationNo, invoiceMain.certificationNo) &&
        Objects.equals(this.importCertNo, invoiceMain.importCertNo) &&
        Objects.equals(this.importCertificateNo, invoiceMain.importCertificateNo) &&
        Objects.equals(this.inspectionNo, invoiceMain.inspectionNo) &&
        Objects.equals(this.commodityInspectionNo, invoiceMain.commodityInspectionNo) &&
        Objects.equals(this.engineNo, invoiceMain.engineNo) &&
        Objects.equals(this.vin, invoiceMain.vin) &&
        Objects.equals(this.vehicleNo, invoiceMain.vehicleNo) &&
        Objects.equals(this.tonnage, invoiceMain.tonnage) &&
        Objects.equals(this.taxPaidProof, invoiceMain.taxPaidProof) &&
        Objects.equals(this.maxCapacity, invoiceMain.maxCapacity) &&
        Objects.equals(this.taxAuthCode, invoiceMain.taxAuthCode) &&
        Objects.equals(this.taxAuthName, invoiceMain.taxAuthName) &&
        Objects.equals(this.chargeTaxAuthorityCode, invoiceMain.chargeTaxAuthorityCode) &&
        Objects.equals(this.chargeTaxAuthorityName, invoiceMain.chargeTaxAuthorityName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taskId, invoiceCode, invoiceNo, paperDrewDate, checkCode, amountWithoutTax, sellerId, sellerTaxNo, sellerName, sellerAddress, sellerTel, sellerAddrTel, sellerBankName, sellerBankAccount, sellerBankNameAccount, sellerBankInfo, purchaserId, purchaserTaxNo, purchaserName, purchaserAddress, purchaserTel, purchaserAddrTel, purchaserBankName, purchaserBankAccount, purchaserBankNameAccount, purchaserBankInfo, taxRate, taxAmount, amountWithTax, machineCode, cipherText, remark, invoiceType, status, provinceCode, provinceName, specialInvoiceFlag, cpyStatus, ctStatus, dqCode, dqName, checkTime, checkNumber, saleListFlag, goodsListFlag, cashierName, checkerName, invoicerName, receivingClerk, organizationCode, vehicleType, vehicleBrand, productionArea, certNo, certificationNo, importCertNo, importCertificateNo, inspectionNo, commodityInspectionNo, engineNo, vin, vehicleNo, tonnage, taxPaidProof, maxCapacity, taxAuthCode, taxAuthName, chargeTaxAuthorityCode, chargeTaxAuthorityName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceMain {\n");
    
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    sellerId: ").append(toIndentedString(sellerId)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddrTel: ").append(toIndentedString(sellerAddrTel)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    sellerBankNameAccount: ").append(toIndentedString(sellerBankNameAccount)).append("\n");
    sb.append("    sellerBankInfo: ").append(toIndentedString(sellerBankInfo)).append("\n");
    sb.append("    purchaserId: ").append(toIndentedString(purchaserId)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddrTel: ").append(toIndentedString(purchaserAddrTel)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    purchaserBankNameAccount: ").append(toIndentedString(purchaserBankNameAccount)).append("\n");
    sb.append("    purchaserBankInfo: ").append(toIndentedString(purchaserBankInfo)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    provinceCode: ").append(toIndentedString(provinceCode)).append("\n");
    sb.append("    provinceName: ").append(toIndentedString(provinceName)).append("\n");
    sb.append("    specialInvoiceFlag: ").append(toIndentedString(specialInvoiceFlag)).append("\n");
    sb.append("    cpyStatus: ").append(toIndentedString(cpyStatus)).append("\n");
    sb.append("    ctStatus: ").append(toIndentedString(ctStatus)).append("\n");
    sb.append("    dqCode: ").append(toIndentedString(dqCode)).append("\n");
    sb.append("    dqName: ").append(toIndentedString(dqName)).append("\n");
    sb.append("    checkTime: ").append(toIndentedString(checkTime)).append("\n");
    sb.append("    checkNumber: ").append(toIndentedString(checkNumber)).append("\n");
    sb.append("    saleListFlag: ").append(toIndentedString(saleListFlag)).append("\n");
    sb.append("    goodsListFlag: ").append(toIndentedString(goodsListFlag)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    receivingClerk: ").append(toIndentedString(receivingClerk)).append("\n");
    sb.append("    organizationCode: ").append(toIndentedString(organizationCode)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("    vehicleBrand: ").append(toIndentedString(vehicleBrand)).append("\n");
    sb.append("    productionArea: ").append(toIndentedString(productionArea)).append("\n");
    sb.append("    certNo: ").append(toIndentedString(certNo)).append("\n");
    sb.append("    certificationNo: ").append(toIndentedString(certificationNo)).append("\n");
    sb.append("    importCertNo: ").append(toIndentedString(importCertNo)).append("\n");
    sb.append("    importCertificateNo: ").append(toIndentedString(importCertificateNo)).append("\n");
    sb.append("    inspectionNo: ").append(toIndentedString(inspectionNo)).append("\n");
    sb.append("    commodityInspectionNo: ").append(toIndentedString(commodityInspectionNo)).append("\n");
    sb.append("    engineNo: ").append(toIndentedString(engineNo)).append("\n");
    sb.append("    vin: ").append(toIndentedString(vin)).append("\n");
    sb.append("    vehicleNo: ").append(toIndentedString(vehicleNo)).append("\n");
    sb.append("    tonnage: ").append(toIndentedString(tonnage)).append("\n");
    sb.append("    taxPaidProof: ").append(toIndentedString(taxPaidProof)).append("\n");
    sb.append("    maxCapacity: ").append(toIndentedString(maxCapacity)).append("\n");
    sb.append("    taxAuthCode: ").append(toIndentedString(taxAuthCode)).append("\n");
    sb.append("    taxAuthName: ").append(toIndentedString(taxAuthName)).append("\n");
    sb.append("    chargeTaxAuthorityCode: ").append(toIndentedString(chargeTaxAuthorityCode)).append("\n");
    sb.append("    chargeTaxAuthorityName: ").append(toIndentedString(chargeTaxAuthorityName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
