package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsInvoiceVerifyStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询发票list返回结果
 */
@ApiModel(description = "查询发票list返回结果")

@JsonInclude(NON_NULL)
public class MsInvoiceVerifyStatusResult {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsInvoiceVerifyStatus> result = new ArrayList<MsInvoiceVerifyStatus>();

  @JsonIgnore
  public MsInvoiceVerifyStatusResult code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 返回码
   * @return code
  **/
  @ApiModelProperty(value = "返回码")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsInvoiceVerifyStatusResult message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @ApiModelProperty(value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsInvoiceVerifyStatusResult result(List<MsInvoiceVerifyStatus> result) {
    this.result = result;
    return this;
  }

  public MsInvoiceVerifyStatusResult addResultItem(MsInvoiceVerifyStatus resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 发票查验状态对象
   * @return result
  **/
  @ApiModelProperty(value = "发票查验状态对象")
  public List<MsInvoiceVerifyStatus> getResult() {
    return result;
  }

  public void setResult(List<MsInvoiceVerifyStatus> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceVerifyStatusResult invoiceVerifyStatusResult = (MsInvoiceVerifyStatusResult) o;
    return Objects.equals(this.code, invoiceVerifyStatusResult.code) &&
        Objects.equals(this.message, invoiceVerifyStatusResult.message) &&
        Objects.equals(this.result, invoiceVerifyStatusResult.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceVerifyStatusResult {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
