package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 验证记录返回对象
 */
@ApiModel(description = "验证记录返回对象")

@JsonInclude(NON_NULL)
public class MsListVerifyRecord {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("verifyStatus")
  private Integer verifyStatus = null;

  @JsonProperty("verifyRemark")
  private String verifyRemark = null;

  @JsonProperty("verifyOrig")
  private Integer verifyOrig = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("verifyTime")
  private Long verifyTime = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public MsListVerifyRecord id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsListVerifyRecord invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型: 增值税专用发票 s 增值税普通发票 c 增值税电子普通发票 ce 增值税普通发票（卷票） ju 通行费增值税电子普通发票 ct 机动车统一销售发票 v 
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型: 增值税专用发票 s 增值税普通发票 c 增值税电子普通发票 ce 增值税普通发票（卷票） ju 通行费增值税电子普通发票 ct 机动车统一销售发票 v ")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsListVerifyRecord invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsListVerifyRecord invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsListVerifyRecord paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 发票开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsListVerifyRecord amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsListVerifyRecord checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public MsListVerifyRecord verifyStatus(Integer verifyStatus) {
    this.verifyStatus = verifyStatus;
    return this;
  }

   /**
   * 验真状态 0-验真中;1--验真成功;2--验真失败;3-验真请求发送失败
   * @return verifyStatus
  **/
  @ApiModelProperty(value = "验真状态 0-验真中;1--验真成功;2--验真失败;3-验真请求发送失败")
  public Integer getVerifyStatus() {
    return verifyStatus;
  }

  public void setVerifyStatus(Integer verifyStatus) {
    this.verifyStatus = verifyStatus;
  }

  @JsonIgnore
  public MsListVerifyRecord verifyRemark(String verifyRemark) {
    this.verifyRemark = verifyRemark;
    return this;
  }

   /**
   * 查验备注
   * @return verifyRemark
  **/
  @ApiModelProperty(value = "查验备注")
  public String getVerifyRemark() {
    return verifyRemark;
  }

  public void setVerifyRemark(String verifyRemark) {
    this.verifyRemark = verifyRemark;
  }

  @JsonIgnore
  public MsListVerifyRecord verifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
    return this;
  }

   /**
   * 验真来源0-初始值;1-扫码;2-手工;3-批量导入;4-底账同步;5-自动
   * @return verifyOrig
  **/
  @ApiModelProperty(value = "验真来源0-初始值;1-扫码;2-手工;3-批量导入;4-底账同步;5-自动")
  public Integer getVerifyOrig() {
    return verifyOrig;
  }

  public void setVerifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
  }

  @JsonIgnore
  public MsListVerifyRecord sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsListVerifyRecord purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsListVerifyRecord amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsListVerifyRecord verifyTime(Long verifyTime) {
    this.verifyTime = verifyTime;
    return this;
  }

   /**
   * Get verifyTime
   * @return verifyTime
  **/
  @ApiModelProperty(value = "")
  public Long getVerifyTime() {
    return verifyTime;
  }

  public void setVerifyTime(Long verifyTime) {
    this.verifyTime = verifyTime;
  }

  @JsonIgnore
  public MsListVerifyRecord status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态0-默认；1-正常；2-红冲；3-作废
   * @return status
  **/
  @ApiModelProperty(value = "状态0-默认；1-正常；2-红冲；3-作废")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListVerifyRecord listVerifyRecord = (MsListVerifyRecord) o;
    return Objects.equals(this.id, listVerifyRecord.id) &&
        Objects.equals(this.invoiceType, listVerifyRecord.invoiceType) &&
        Objects.equals(this.invoiceCode, listVerifyRecord.invoiceCode) &&
        Objects.equals(this.invoiceNo, listVerifyRecord.invoiceNo) &&
        Objects.equals(this.paperDrewDate, listVerifyRecord.paperDrewDate) &&
        Objects.equals(this.amountWithoutTax, listVerifyRecord.amountWithoutTax) &&
        Objects.equals(this.checkCode, listVerifyRecord.checkCode) &&
        Objects.equals(this.verifyStatus, listVerifyRecord.verifyStatus) &&
        Objects.equals(this.verifyRemark, listVerifyRecord.verifyRemark) &&
        Objects.equals(this.verifyOrig, listVerifyRecord.verifyOrig) &&
        Objects.equals(this.sellerName, listVerifyRecord.sellerName) &&
        Objects.equals(this.purchaserName, listVerifyRecord.purchaserName) &&
        Objects.equals(this.amountWithTax, listVerifyRecord.amountWithTax) &&
        Objects.equals(this.verifyTime, listVerifyRecord.verifyTime) &&
        Objects.equals(this.status, listVerifyRecord.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, invoiceType, invoiceCode, invoiceNo, paperDrewDate, amountWithoutTax, checkCode, verifyStatus, verifyRemark, verifyOrig, sellerName, purchaserName, amountWithTax, verifyTime, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListVerifyRecord {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    verifyStatus: ").append(toIndentedString(verifyStatus)).append("\n");
    sb.append("    verifyRemark: ").append(toIndentedString(verifyRemark)).append("\n");
    sb.append("    verifyOrig: ").append(toIndentedString(verifyOrig)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    verifyTime: ").append(toIndentedString(verifyTime)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
