package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票查验请求
 */
@ApiModel(description = "发票查验请求")

@JsonInclude(NON_NULL)
public class MsVerifyRequest {
  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("verifyOrig")
  private Integer verifyOrig = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("operatorName")
  private String operatorName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonIgnore
  public MsVerifyRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsVerifyRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsVerifyRequest paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsVerifyRequest checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码,增值税普票必填
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码,增值税普票必填")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public MsVerifyRequest amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额,增值税专票必填
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额,增值税专票必填")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsVerifyRequest verifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
    return this;
  }

   /**
   * 查验请求来源
   * @return verifyOrig
  **/
  @ApiModelProperty(value = "查验请求来源")
  public Integer getVerifyOrig() {
    return verifyOrig;
  }

  public void setVerifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
  }

  @JsonIgnore
  public MsVerifyRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsVerifyRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsVerifyRequest operatorName(String operatorName) {
    this.operatorName = operatorName;
    return this;
  }

   /**
   * 操作者姓名
   * @return operatorName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getOperatorName() {
    return operatorName;
  }

  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  @JsonIgnore
  public MsVerifyRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsVerifyRequest verifyRequest = (MsVerifyRequest) o;
    return Objects.equals(this.invoiceCode, verifyRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, verifyRequest.invoiceNo) &&
        Objects.equals(this.paperDrewDate, verifyRequest.paperDrewDate) &&
        Objects.equals(this.checkCode, verifyRequest.checkCode) &&
        Objects.equals(this.amountWithoutTax, verifyRequest.amountWithoutTax) &&
        Objects.equals(this.verifyOrig, verifyRequest.verifyOrig) &&
        Objects.equals(this.purchaserTaxNo, verifyRequest.purchaserTaxNo) &&
        Objects.equals(this.operatorId, verifyRequest.operatorId) &&
        Objects.equals(this.operatorName, verifyRequest.operatorName) &&
        Objects.equals(this.groupId, verifyRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceCode, invoiceNo, paperDrewDate, checkCode, amountWithoutTax, verifyOrig, purchaserTaxNo, operatorId, operatorName, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsVerifyRequest {\n");
    
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    verifyOrig: ").append(toIndentedString(verifyOrig)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    operatorName: ").append(toIndentedString(operatorName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
