package com.xforceplus.phoenix.verify.client.api;

import com.xforceplus.phoenix.verify.client.model.MsBatchVerifyRequest;
import com.xforceplus.phoenix.verify.client.model.MsBatchVerifyResult;
import com.xforceplus.phoenix.verify.client.model.MsDelVerifyRequest;
import com.xforceplus.phoenix.verify.client.model.MsExportInvoicesRequest;
import com.xforceplus.phoenix.verify.client.model.MsExportTemplateResult;
import com.xforceplus.phoenix.verify.client.model.MsFiltersConditionRequest;
import com.xforceplus.phoenix.verify.client.model.MsGetVryDetailsRequest;
import com.xforceplus.phoenix.verify.client.model.MsGetVryNineEleRequest;
import com.xforceplus.phoenix.verify.client.model.MsImportFileRequest;
import com.xforceplus.phoenix.verify.client.model.MsInvoiceDetailsResult;
import com.xforceplus.phoenix.verify.client.model.MsInvoiceVerifyStatusResult;
import com.xforceplus.phoenix.verify.client.model.MsJudgeInvoiceIsCheckRequest;
import com.xforceplus.phoenix.verify.client.model.MsListInvoiceRequest;
import com.xforceplus.phoenix.verify.client.model.MsListInvoiceResult;
import com.xforceplus.phoenix.verify.client.model.MsListVerifyRecordResult;
import com.xforceplus.phoenix.verify.client.model.MsResponse;
import com.xforceplus.phoenix.verify.client.model.MsVerifyRequest;
import com.xforceplus.phoenix.verify.client.model.MsVryNineEleResult;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoiceVerify", description = "the invoiceVerify API")
public interface InvoiceVerifyApi {

    @ApiOperation(value = "运维系统发起查验", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class) })
    @RequestMapping(value = "/invoiceVerify/batchOpsVerify",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     com.xforceplus.xplatframework.model.Response batchOpsVerify(@ApiParam(value = "查询条件" ,required=true ) @RequestBody MsFiltersConditionRequest data);


    @ApiOperation(value = "发票查验请求批量上传", notes = "", response = MsBatchVerifyResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsBatchVerifyResult.class) })
    @RequestMapping(value = "/invoiceVerify/batchUpload",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBatchVerifyResult batchUpload(@ApiParam(value = "发票批量查验请求" ,required=true ) @RequestBody MsBatchVerifyRequest data);


    @ApiOperation(value = "删除发票查验数据", notes = "", response = MsBatchVerifyResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsBatchVerifyResult.class) })
    @RequestMapping(value = "/invoiceVerify/deleteVerifyInvoice",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBatchVerifyResult deleteVerifyInvoice(@ApiParam(value = "删除发票查验数据请求" ,required=true ) @RequestBody MsDelVerifyRequest data);


    @ApiOperation(value = "导出发票信息", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class) })
    @RequestMapping(value = "/invoiceVerify/exportInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     com.xforceplus.xplatframework.model.Response exportInvoices(@ApiParam(value = "导出发票请求" ,required=true ) @RequestBody MsExportInvoicesRequest data);


    @ApiOperation(value = "导出模板", notes = "", response = MsExportTemplateResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsExportTemplateResult.class) })
    @RequestMapping(value = "/invoiceVerify/exportTemplate",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsExportTemplateResult exportTemplate();


    @ApiOperation(value = "查询查验明细", notes = "", response = MsInvoiceDetailsResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsInvoiceDetailsResult.class) })
    @RequestMapping(value = "/invoiceVerify/getDetailsVerifyInvoice",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceDetailsResult getDetailsVerifyInvoice(@ApiParam(value = "发票明细查询请求" ,required=true ) @RequestBody MsGetVryDetailsRequest data);


    @ApiOperation(value = "获取发票9要素", notes = "", response = MsVryNineEleResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsVryNineEleResult.class) })
    @RequestMapping(value = "/invoiceVerify/getInvoiceNineEle",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsVryNineEleResult getInvoiceNineEle(@ApiParam(value = "获取发票9要素" ,required=true ) @RequestBody MsGetVryNineEleRequest data);


    @ApiOperation(value = "获取发票查验状态", notes = "", response = MsInvoiceVerifyStatusResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsInvoiceVerifyStatusResult.class) })
    @RequestMapping(value = "/invoiceVerify/getVerifyStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceVerifyStatusResult getVerifyStatus(@ApiParam(value = "获取发票查验状态请求" ,required=true ) @RequestBody MsDelVerifyRequest data);


    @ApiOperation(value = "导入批量查验数据", notes = "", response = MsBatchVerifyResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsBatchVerifyResult.class) })
    @RequestMapping(value = "/invoiceVerify/importTemplate",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBatchVerifyResult importTemplate(@ApiParam(value = "oss文件地址" ,required=true ) @RequestBody MsImportFileRequest data);


    @ApiOperation(value = "判断发票是否已经查验", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "", response = com.xforceplus.xplatframework.model.Response.class) })
    @RequestMapping(value = "/invoiceVerify/judgeInvoiceIsCheck",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     com.xforceplus.xplatframework.model.Response judgeInvoiceIsCheck(@ApiParam(value = "入参" ,required=true ) @RequestBody MsJudgeInvoiceIsCheckRequest request);


    @ApiOperation(value = "查询查验结果", notes = "", response = MsListInvoiceResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = MsListInvoiceResult.class) })
    @RequestMapping(value = "/invoiceVerify/listVerifyInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListInvoiceResult listVerifyInvoices(@ApiParam(value = "发票信息查询请求" ,required=true ) @RequestBody MsListInvoiceRequest data);


    @ApiOperation(value = "运维系统查询查验记录", notes = "", response = MsListVerifyRecordResult.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表", response = MsListVerifyRecordResult.class) })
    @RequestMapping(value = "/invoiceVerify/listVerifyRecord",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListVerifyRecordResult listVerifyRecords(@ApiParam(value = "查询条件" ,required=true ) @RequestBody MsFiltersConditionRequest data);


    @ApiOperation(value = "发票查验请求上传", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags={ "InvoiceVerify", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class) })
    @RequestMapping(value = "/invoiceVerify/upload",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     com.xforceplus.xplatframework.model.Response upload(@ApiParam(value = "发票查验请求" ,required=true ) @RequestBody MsVerifyRequest data);

}
