package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsBatchCheckInvoiceMainResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票批量查验返回对象
 */
@ApiModel(description = "发票批量查验返回对象")

@JsonInclude(NON_NULL)
public class MsBatchCheckInvoiceMainResults {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private MsBatchCheckInvoiceMainResult result = null;

  @JsonIgnore
  public MsBatchCheckInvoiceMainResults code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceMainResults message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceMainResults result(MsBatchCheckInvoiceMainResult result) {
    this.result = result;
    return this;
  }

   /**
   * 批量查验返回对象
   * @return result
  **/
  @ApiModelProperty(value = "批量查验返回对象")
  public MsBatchCheckInvoiceMainResult getResult() {
    return result;
  }

  public void setResult(MsBatchCheckInvoiceMainResult result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchCheckInvoiceMainResults batchCheckInvoiceMainResults = (MsBatchCheckInvoiceMainResults) o;
    return Objects.equals(this.code, batchCheckInvoiceMainResults.code) &&
        Objects.equals(this.message, batchCheckInvoiceMainResults.message) &&
        Objects.equals(this.result, batchCheckInvoiceMainResults.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchCheckInvoiceMainResults {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
