package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsBatchCheckInvoiceMain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 批量发票查验请求
 */
@ApiModel(description = "批量发票查验请求")

@JsonInclude(NON_NULL)
public class MsBatchCheckInvoiceRequest {
  @JsonProperty("invoiceMains")
  private List<MsBatchCheckInvoiceMain> invoiceMains = new ArrayList<MsBatchCheckInvoiceMain>();

  @JsonProperty("verifyOrig")
  private Integer verifyOrig = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("operatorName")
  private String operatorName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonIgnore
  public MsBatchCheckInvoiceRequest invoiceMains(List<MsBatchCheckInvoiceMain> invoiceMains) {
    this.invoiceMains = invoiceMains;
    return this;
  }

  public MsBatchCheckInvoiceRequest addInvoiceMainsItem(MsBatchCheckInvoiceMain invoiceMainsItem) {
    this.invoiceMains.add(invoiceMainsItem);
    return this;
  }

   /**
   * 验真四要素
   * @return invoiceMains
  **/
  @ApiModelProperty(value = "验真四要素")
  public List<MsBatchCheckInvoiceMain> getInvoiceMains() {
    return invoiceMains;
  }

  public void setInvoiceMains(List<MsBatchCheckInvoiceMain> invoiceMains) {
    this.invoiceMains = invoiceMains;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceRequest verifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
    return this;
  }

   /**
   * 查验请求来源
   * @return verifyOrig
  **/
  @ApiModelProperty(value = "查验请求来源")
  public Integer getVerifyOrig() {
    return verifyOrig;
  }

  public void setVerifyOrig(Integer verifyOrig) {
    this.verifyOrig = verifyOrig;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceRequest operatorName(String operatorName) {
    this.operatorName = operatorName;
    return this;
  }

   /**
   * 操作者姓名
   * @return operatorName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getOperatorName() {
    return operatorName;
  }

  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchCheckInvoiceRequest batchCheckInvoiceRequest = (MsBatchCheckInvoiceRequest) o;
    return Objects.equals(this.invoiceMains, batchCheckInvoiceRequest.invoiceMains) &&
        Objects.equals(this.verifyOrig, batchCheckInvoiceRequest.verifyOrig) &&
        Objects.equals(this.purchaserTaxNo, batchCheckInvoiceRequest.purchaserTaxNo) &&
        Objects.equals(this.operatorId, batchCheckInvoiceRequest.operatorId) &&
        Objects.equals(this.operatorName, batchCheckInvoiceRequest.operatorName) &&
        Objects.equals(this.groupId, batchCheckInvoiceRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceMains, verifyOrig, purchaserTaxNo, operatorId, operatorName, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchCheckInvoiceRequest {\n");
    
    sb.append("    invoiceMains: ").append(toIndentedString(invoiceMains)).append("\n");
    sb.append("    verifyOrig: ").append(toIndentedString(verifyOrig)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    operatorName: ").append(toIndentedString(operatorName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
