package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsBatchCheckInvoiceMainResults;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 批量验真反馈
 */
@ApiModel(description = "批量验真反馈")

@JsonInclude(NON_NULL)
public class MsBatchCheckInvoiceResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("results")
  private List<MsBatchCheckInvoiceMainResults> results = new ArrayList<MsBatchCheckInvoiceMainResults>();

  @JsonIgnore
  public MsBatchCheckInvoiceResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsBatchCheckInvoiceResponse results(List<MsBatchCheckInvoiceMainResults> results) {
    this.results = results;
    return this;
  }

  public MsBatchCheckInvoiceResponse addResultsItem(MsBatchCheckInvoiceMainResults resultsItem) {
    this.results.add(resultsItem);
    return this;
  }

   /**
   * 批量验真返回对象
   * @return results
  **/
  @ApiModelProperty(value = "批量验真返回对象")
  public List<MsBatchCheckInvoiceMainResults> getResults() {
    return results;
  }

  public void setResults(List<MsBatchCheckInvoiceMainResults> results) {
    this.results = results;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchCheckInvoiceResponse batchCheckInvoiceResponse = (MsBatchCheckInvoiceResponse) o;
    return Objects.equals(this.code, batchCheckInvoiceResponse.code) &&
        Objects.equals(this.message, batchCheckInvoiceResponse.message) &&
        Objects.equals(this.results, batchCheckInvoiceResponse.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, results);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchCheckInvoiceResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
