package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导出发票请求
 */
@ApiModel(description = "导出发票请求")

@JsonInclude(NON_NULL)
public class MsExportInvoicesRequest {
  @JsonProperty("exportType")
  private Integer exportType = null;

  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("operatorName")
  private String operatorName = null;

  @JsonIgnore
  public MsExportInvoicesRequest exportType(Integer exportType) {
    this.exportType = exportType;
    return this;
  }

   /**
   * 导出类型0页面导出1打印下载
   * @return exportType
  **/
  @ApiModelProperty(value = "导出类型0页面导出1打印下载")
  public Integer getExportType() {
    return exportType;
  }

  public void setExportType(Integer exportType) {
    this.exportType = exportType;
  }

  @JsonIgnore
  public MsExportInvoicesRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsExportInvoicesRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 查验表发票主键id数组
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "查验表发票主键id数组")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public MsExportInvoicesRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsExportInvoicesRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsExportInvoicesRequest operatorName(String operatorName) {
    this.operatorName = operatorName;
    return this;
  }

   /**
   * 操作者姓名
   * @return operatorName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getOperatorName() {
    return operatorName;
  }

  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsExportInvoicesRequest exportInvoicesRequest = (MsExportInvoicesRequest) o;
    return Objects.equals(this.exportType, exportInvoicesRequest.exportType) &&
        Objects.equals(this.invoiceIds, exportInvoicesRequest.invoiceIds) &&
        Objects.equals(this.groupid, exportInvoicesRequest.groupid) &&
        Objects.equals(this.operatorId, exportInvoicesRequest.operatorId) &&
        Objects.equals(this.operatorName, exportInvoicesRequest.operatorName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(exportType, invoiceIds, groupid, operatorId, operatorName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsExportInvoicesRequest {\n");
    
    sb.append("    exportType: ").append(toIndentedString(exportType)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    operatorName: ").append(toIndentedString(operatorName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
