package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导入文件信息
 */
@ApiModel(description = "导入文件信息")

@JsonInclude(NON_NULL)
public class MsImportFileRequest {
  @JsonProperty("ossKey")
  private String ossKey = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("operatorName")
  private String operatorName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonIgnore
  public MsImportFileRequest ossKey(String ossKey) {
    this.ossKey = ossKey;
    return this;
  }

   /**
   * oss文件路径
   * @return ossKey
  **/
  @ApiModelProperty(value = "oss文件路径")
  public String getOssKey() {
    return ossKey;
  }

  public void setOssKey(String ossKey) {
    this.ossKey = ossKey;
  }

  @JsonIgnore
  public MsImportFileRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsImportFileRequest operatorName(String operatorName) {
    this.operatorName = operatorName;
    return this;
  }

   /**
   * 操作者姓名
   * @return operatorName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getOperatorName() {
    return operatorName;
  }

  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  @JsonIgnore
  public MsImportFileRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportFileRequest importFileRequest = (MsImportFileRequest) o;
    return Objects.equals(this.ossKey, importFileRequest.ossKey) &&
        Objects.equals(this.operatorId, importFileRequest.operatorId) &&
        Objects.equals(this.operatorName, importFileRequest.operatorName) &&
        Objects.equals(this.groupId, importFileRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ossKey, operatorId, operatorName, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportFileRequest {\n");
    
    sb.append("    ossKey: ").append(toIndentedString(ossKey)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    operatorName: ").append(toIndentedString(operatorName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
