package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票查验请求
 */
@ApiModel(description = "发票查验请求")

@JsonInclude(NON_NULL)
public class MsInvoiceVerifyMain {
  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonIgnore
  public MsInvoiceVerifyMain invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsInvoiceVerifyMain invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsInvoiceVerifyMain paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsInvoiceVerifyMain checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码,增值税普票必填
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码,增值税普票必填")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public MsInvoiceVerifyMain amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额,增值税专票必填
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额,增值税专票必填")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceVerifyMain invoiceVerifyMain = (MsInvoiceVerifyMain) o;
    return Objects.equals(this.invoiceCode, invoiceVerifyMain.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoiceVerifyMain.invoiceNo) &&
        Objects.equals(this.paperDrewDate, invoiceVerifyMain.paperDrewDate) &&
        Objects.equals(this.checkCode, invoiceVerifyMain.checkCode) &&
        Objects.equals(this.amountWithoutTax, invoiceVerifyMain.amountWithoutTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceCode, invoiceNo, paperDrewDate, checkCode, amountWithoutTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceVerifyMain {\n");
    
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
