package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsInvoiceCriteria;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票信息查询请求
 */
@ApiModel(description = "发票信息查询请求")

@JsonInclude(NON_NULL)
public class MsListInvoiceRequest {
  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("currentPage")
  private Integer currentPage = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("invoiceCriteria")
  private MsInvoiceCriteria invoiceCriteria = null;

  @JsonIgnore
  public MsListInvoiceRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页显示数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页显示数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsListInvoiceRequest currentPage(Integer currentPage) {
    this.currentPage = currentPage;
    return this;
  }

   /**
   * 当前页
   * @return currentPage
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getCurrentPage() {
    return currentPage;
  }

  public void setCurrentPage(Integer currentPage) {
    this.currentPage = currentPage;
  }

  @JsonIgnore
  public MsListInvoiceRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsListInvoiceRequest invoiceCriteria(MsInvoiceCriteria invoiceCriteria) {
    this.invoiceCriteria = invoiceCriteria;
    return this;
  }

   /**
   * 发票信息查询条件
   * @return invoiceCriteria
  **/
  @ApiModelProperty(value = "发票信息查询条件")
  public MsInvoiceCriteria getInvoiceCriteria() {
    return invoiceCriteria;
  }

  public void setInvoiceCriteria(MsInvoiceCriteria invoiceCriteria) {
    this.invoiceCriteria = invoiceCriteria;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListInvoiceRequest listInvoiceRequest = (MsListInvoiceRequest) o;
    return Objects.equals(this.pageSize, listInvoiceRequest.pageSize) &&
        Objects.equals(this.currentPage, listInvoiceRequest.currentPage) &&
        Objects.equals(this.operatorId, listInvoiceRequest.operatorId) &&
        Objects.equals(this.invoiceCriteria, listInvoiceRequest.invoiceCriteria);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageSize, currentPage, operatorId, invoiceCriteria);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListInvoiceRequest {\n");
    
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    currentPage: ").append(toIndentedString(currentPage)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    invoiceCriteria: ").append(toIndentedString(invoiceCriteria)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
