package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.verify.client.model.MsListVerifyRecord;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询验真记录list返回结果
 */
@ApiModel(description = "查询验真记录list返回结果")

@JsonInclude(NON_NULL)
public class MsListVerifyRecordResult {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("result")
  private List<MsListVerifyRecord> result = new ArrayList<MsListVerifyRecord>();

  @JsonIgnore
  public MsListVerifyRecordResult code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 返回码
   * @return code
  **/
  @ApiModelProperty(value = "返回码")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsListVerifyRecordResult message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @ApiModelProperty(value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsListVerifyRecordResult total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 数量
   * @return total
  **/
  @ApiModelProperty(value = "数量")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsListVerifyRecordResult result(List<MsListVerifyRecord> result) {
    this.result = result;
    return this;
  }

  public MsListVerifyRecordResult addResultItem(MsListVerifyRecord resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 验证记录列表
   * @return result
  **/
  @ApiModelProperty(value = "验证记录列表")
  public List<MsListVerifyRecord> getResult() {
    return result;
  }

  public void setResult(List<MsListVerifyRecord> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListVerifyRecordResult listVerifyRecordResult = (MsListVerifyRecordResult) o;
    return Objects.equals(this.code, listVerifyRecordResult.code) &&
        Objects.equals(this.message, listVerifyRecordResult.message) &&
        Objects.equals(this.total, listVerifyRecordResult.total) &&
        Objects.equals(this.result, listVerifyRecordResult.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListVerifyRecordResult {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
