package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求字段
 */
@ApiModel(description = "请求字段")

@JsonInclude(NON_NULL)
public class MsRequestField {
  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonProperty("filedType")
  private String filedType = null;

  @JsonProperty("fieldQueryType")
  private String fieldQueryType = null;

  @JsonProperty("virtual")
  private String virtual = null;

  @JsonProperty("value")
  private List<String> value = new ArrayList<String>();

  @JsonIgnore
  public MsRequestField fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * 字段名
   * @return fieldName
  **/
  @ApiModelProperty(value = "字段名")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @JsonIgnore
  public MsRequestField filedType(String filedType) {
    this.filedType = filedType;
    return this;
  }

   /**
   * 字段类型
   * @return filedType
  **/
  @ApiModelProperty(value = "字段类型")
  public String getFiledType() {
    return filedType;
  }

  public void setFiledType(String filedType) {
    this.filedType = filedType;
  }

  @JsonIgnore
  public MsRequestField fieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
    return this;
  }

   /**
   * 操作符
   * @return fieldQueryType
  **/
  @ApiModelProperty(value = "操作符")
  public String getFieldQueryType() {
    return fieldQueryType;
  }

  public void setFieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
  }

  @JsonIgnore
  public MsRequestField virtual(String virtual) {
    this.virtual = virtual;
    return this;
  }

   /**
   * 虚拟标识
   * @return virtual
  **/
  @ApiModelProperty(value = "虚拟标识")
  public String getVirtual() {
    return virtual;
  }

  public void setVirtual(String virtual) {
    this.virtual = virtual;
  }

  @JsonIgnore
  public MsRequestField value(List<String> value) {
    this.value = value;
    return this;
  }

  public MsRequestField addValueItem(String valueItem) {
    this.value.add(valueItem);
    return this;
  }

   /**
   * 字段值
   * @return value
  **/
  @ApiModelProperty(value = "字段值")
  public List<String> getValue() {
    return value;
  }

  public void setValue(List<String> value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsRequestField requestField = (MsRequestField) o;
    return Objects.equals(this.fieldName, requestField.fieldName) &&
        Objects.equals(this.filedType, requestField.filedType) &&
        Objects.equals(this.fieldQueryType, requestField.fieldQueryType) &&
        Objects.equals(this.virtual, requestField.virtual) &&
        Objects.equals(this.value, requestField.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, filedType, fieldQueryType, virtual, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsRequestField {\n");
    
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    filedType: ").append(toIndentedString(filedType)).append("\n");
    sb.append("    fieldQueryType: ").append(toIndentedString(fieldQueryType)).append("\n");
    sb.append("    virtual: ").append(toIndentedString(virtual)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
