/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.consist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.apollo.core.exception.SysException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SealedRecMessage {
    private Header header;
    private Payload payload;

    @JsonCreator
    public SealedRecMessage(@JsonProperty(value="header") Header header, @JsonProperty(value="payload") Payload payload) {
        if (header == null || payload == null) {
            throw new SysException(SysException.SysCode.SYS, "header \u548c payload \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.header = header;
        this.payload = payload;
    }

    @JsonCreator
    public SealedRecMessage() {
    }

    public Header getHeader() {
        return this.header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SealedRecMessage)) {
            return false;
        }
        SealedRecMessage other = (SealedRecMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Payload this$payload = this.getPayload();
        Payload other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SealedRecMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Payload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    public String toString() {
        return "SealedRecMessage(header=" + this.getHeader() + ", payload=" + this.getPayload() + ")";
    }

    public static class Header
    implements Serializable {
        private static final long serialVersionUID = 7746151751986659236L;
        public static final String TYPE_DATA = "data";
        public static final String TYPE_FILE = "file";
        private String msgId;
        private String createTime;
        private String userId;
        private Integer status;
        private String requestName;
        private String responseName;
        private String type = "data";
        private String payLoadId;
        private Map<String, String> others = new HashMap<String, String>();

        public Header() {
        }

        @JsonCreator
        public Header(@JsonProperty(value="userId") String userId, @JsonProperty(value="requestName") String requestName, @JsonProperty(value="others") Map<String, String> others) {
            if (!StringUtils.isBlank((CharSequence)userId) && !StringUtils.isBlank((CharSequence)requestName)) {
                this.userId = userId;
                this.msgId = UUID.randomUUID() + "_" + userId;
                this.createTime = DateFormatUtils.format((Calendar)Calendar.getInstance(), (String)"yyyy-MM-dd HH:mm:ss");
                this.requestName = requestName;
                if (null != others) {
                    this.others.putAll(others);
                    if (!requestName.contains("keepAlived") && null != others.get("payLoadId")) {
                        this.payLoadId = others.get("payLoadId").toString();
                    }
                }
            } else {
                throw new SysException(SysException.SysCode.SYS, "userId \u548c requestName \u4e0d\u80fd\u4e3a\u7a7a!");
            }
        }

        public String getMsgId() {
            return this.msgId;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public String getUserId() {
            return this.userId;
        }

        public Integer getStatus() {
            return this.status;
        }

        public String getRequestName() {
            return this.requestName;
        }

        public String getResponseName() {
            return this.responseName;
        }

        public String getType() {
            return this.type;
        }

        public String getPayLoadId() {
            return this.payLoadId;
        }

        public Map<String, String> getOthers() {
            return this.others;
        }

        public void setMsgId(String msgId) {
            this.msgId = msgId;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setRequestName(String requestName) {
            this.requestName = requestName;
        }

        public void setResponseName(String responseName) {
            this.responseName = responseName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setPayLoadId(String payLoadId) {
            this.payLoadId = payLoadId;
        }

        public void setOthers(Map<String, String> others) {
            this.others = others;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$msgId = this.getMsgId();
            String other$msgId = other.getMsgId();
            if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
                return false;
            }
            String this$createTime = this.getCreateTime();
            String other$createTime = other.getCreateTime();
            if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$requestName = this.getRequestName();
            String other$requestName = other.getRequestName();
            if (this$requestName == null ? other$requestName != null : !this$requestName.equals(other$requestName)) {
                return false;
            }
            String this$responseName = this.getResponseName();
            String other$responseName = other.getResponseName();
            if (this$responseName == null ? other$responseName != null : !this$responseName.equals(other$responseName)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$payLoadId = this.getPayLoadId();
            String other$payLoadId = other.getPayLoadId();
            if (this$payLoadId == null ? other$payLoadId != null : !this$payLoadId.equals(other$payLoadId)) {
                return false;
            }
            Map<String, String> this$others = this.getOthers();
            Map<String, String> other$others = other.getOthers();
            return !(this$others == null ? other$others != null : !((Object)this$others).equals(other$others));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Header;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $msgId = this.getMsgId();
            result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
            String $createTime = this.getCreateTime();
            result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $requestName = this.getRequestName();
            result = result * 59 + ($requestName == null ? 43 : $requestName.hashCode());
            String $responseName = this.getResponseName();
            result = result * 59 + ($responseName == null ? 43 : $responseName.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $payLoadId = this.getPayLoadId();
            result = result * 59 + ($payLoadId == null ? 43 : $payLoadId.hashCode());
            Map<String, String> $others = this.getOthers();
            result = result * 59 + ($others == null ? 43 : ((Object)$others).hashCode());
            return result;
        }

        public String toString() {
            return "SealedRecMessage.Header(msgId=" + this.getMsgId() + ", createTime=" + this.getCreateTime() + ", userId=" + this.getUserId() + ", status=" + this.getStatus() + ", requestName=" + this.getRequestName() + ", responseName=" + this.getResponseName() + ", type=" + this.getType() + ", payLoadId=" + this.getPayLoadId() + ", others=" + this.getOthers() + ")";
        }
    }

    public static class Payload
    implements Serializable {
        private static final long serialVersionUID = 9179000963472512014L;
        private Object obj;

        public Payload() {
        }

        @JsonCreator
        public Payload(@JsonProperty(value="obj") Object obj) {
            this.obj = obj;
        }

        public Object getObj() {
            return this.obj;
        }

        public void setObj(Object obj) {
            this.obj = obj;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payload)) {
                return false;
            }
            Payload other = (Payload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$obj = this.getObj();
            Object other$obj = other.getObj();
            return !(this$obj == null ? other$obj != null : !this$obj.equals(other$obj));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Payload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $obj = this.getObj();
            result = result * 59 + ($obj == null ? 43 : $obj.hashCode());
            return result;
        }

        public String toString() {
            return "SealedRecMessage.Payload(obj=" + this.getObj() + ")";
        }
    }
}

