/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public enum InvoiceFileTypeEnum {
    TYPE_OF_JPG(0, "\u56fe\u7247(jpg)", "jpg"),
    TYPE_OF_PDF(1, "pdf", "pdf"),
    TYPE_OF_OFD(2, "ofd", "ofd"),
    TYPE_OF_JPEG(3, "\u56fe\u7247(jpeg)", "jpeg"),
    TYPE_OF_XML(4, "xml", "xml");

    private Integer invoiceFileType;
    private String msgTip;
    private String suffix;

    private InvoiceFileTypeEnum(Integer invoiceFileType, String msgTip, String suffix) {
        this.invoiceFileType = invoiceFileType;
        this.msgTip = msgTip;
        this.suffix = suffix;
    }

    public static Boolean isImg(Integer type) {
        List collect = InvoiceFileTypeEnum.getImgs().stream().filter(invoiceFileTypeEnum -> invoiceFileTypeEnum.invoiceFileType == type).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(collect);
    }

    public static Optional<Integer> getinvoiceFileTypeResult(String suffix) {
        Optional<Integer> op = Arrays.stream(InvoiceFileTypeEnum.values()).filter(s -> StringUtils.equals((CharSequence)s.suffix, (CharSequence)suffix.toLowerCase())).findFirst().map(InvoiceFileTypeEnum::getInvoiceFileType);
        return op;
    }

    private static EnumSet<InvoiceFileTypeEnum> getImgs() {
        return EnumSet.of(TYPE_OF_JPG, TYPE_OF_JPEG);
    }

    public Integer getInvoiceFileType() {
        return this.invoiceFileType;
    }

    public String getMsgTip() {
        return this.msgTip;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

