/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public enum InvoiceKindEnum {
    SPECIAL_INVOICE("1", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968-\u56fe\u7247"),
    GENERAL_INVOICE("2", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968-\u56fe\u7247"),
    ORDINARY_INVOICE("3", "\u975e\u589e\u503c\u7a0e\u53d1\u7968(\u666e\u901a\u53d1\u7968)-\u56fe\u7247"),
    ELECTRONIC_INVOICE("4", "\u7535\u5b50\u53d1\u7968\u539f\u4ef6");

    private String invoiceKind;
    private String msgTip;

    private InvoiceKindEnum(String invoiceKind, String msgTip) {
        this.invoiceKind = invoiceKind;
        this.msgTip = msgTip;
    }

    public static Boolean isElectronicInvoice(String invoiceKind) {
        List collect = InvoiceKindEnum.electronicInvoices().stream().filter(invoiceKindEnum -> StringUtils.equals((CharSequence)invoiceKindEnum.invoiceKind, (CharSequence)invoiceKind)).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(collect);
    }

    public static Boolean isValueAddedTax(String invoiceKind) {
        List collect = InvoiceKindEnum.valueAddedTax().stream().filter(invoiceKindEnum -> StringUtils.equals((CharSequence)invoiceKindEnum.invoiceKind, (CharSequence)invoiceKind)).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(collect);
    }

    private static EnumSet<InvoiceKindEnum> valueAddedTax() {
        return EnumSet.of(SPECIAL_INVOICE, GENERAL_INVOICE, ELECTRONIC_INVOICE);
    }

    private static EnumSet<InvoiceKindEnum> electronicInvoices() {
        return EnumSet.of(ELECTRONIC_INVOICE);
    }

    public String getInvoiceKind() {
        return this.invoiceKind;
    }

    public String getMsgTip() {
        return this.msgTip;
    }
}

