/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum InvoiceTypeEnum {
    SPECIAL_INVOICE("s", "01", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    MOTOR_INVOICE("v", "03", "\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968"),
    GENERAL_INVOICE("c", "04", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968"),
    BLOCK_CHAIN_INVOICE("cb", "07", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u533a\u5757\u94fe\uff09"),
    ELECTRONIC_INVOICE("se", "08", "\u589e\u503c\u7535\u5b50\u4e13\u7528\u53d1\u7968"),
    E_INVOICE("ce", "10", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968"),
    VOLUME_INVOICE("ju", "11", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09"),
    TOLLS_INVOICE("ct", "14", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u901a\u884c\u8d39\uff09"),
    QC_INVOICE("qc", "16", "\u5168\u7535\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09"),
    CK_INVOICE("", "17", "\u6d77\u5173\u7f34\u6b3e\u4e66"),
    QS_INVOICE("qs", "18", "\u5168\u7535\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09"),
    SG_INVOICE("", "24", "\u51fa\u53e3\u8f6c\u5185\u9500\u53d1\u7968"),
    CKSG_INVOICE("", "30", "\u51fa\u53e3\u8f6c\u5185\u9500\u6d77\u5173\u7f34\u6b3e\u4e66"),
    CKSE_INVOICE("", "80", "\u51fa\u53e3\u8f6c\u5185\u9500\u4e13\u7528\u7535\u5b50\u53d1\u7968");

    private String invoiceType;
    private String resultCode;
    private String resultTip;

    public static Optional<String> getResultCode(String invoiceType) {
        return Arrays.stream(InvoiceTypeEnum.values()).filter(s -> s.getInvoiceType().equalsIgnoreCase(invoiceType)).findFirst().map(InvoiceTypeEnum::getResultCode);
    }

    public static Optional<String> getInvoiceType(String resultCode) {
        return Arrays.stream(InvoiceTypeEnum.values()).filter(s -> s.getResultCode().equalsIgnoreCase(resultCode)).findFirst().map(InvoiceTypeEnum::getInvoiceType);
    }

    public static Map<String, InvoiceTypeEnum> invoiceTypeMap() {
        return Arrays.stream(InvoiceTypeEnum.values()).collect(Collectors.toMap(InvoiceTypeEnum::getResultCode, s -> s));
    }

    public static EnumSet<InvoiceTypeEnum> specialInvoiceEnums() {
        return EnumSet.of(SPECIAL_INVOICE, ELECTRONIC_INVOICE, QS_INVOICE);
    }

    public static EnumSet<InvoiceTypeEnum> electronicInvoiceEnums() {
        return EnumSet.of(ELECTRONIC_INVOICE, E_INVOICE, QC_INVOICE, QS_INVOICE);
    }

    public static List<String> electronicInvoices() {
        return InvoiceTypeEnum.electronicInvoiceEnums().stream().map(InvoiceTypeEnum::getResultCode).collect(Collectors.toList());
    }

    public static EnumSet<InvoiceTypeEnum> generalInvoiceEnums() {
        return EnumSet.of(GENERAL_INVOICE, E_INVOICE, VOLUME_INVOICE, TOLLS_INVOICE, QC_INVOICE);
    }

    public static EnumSet<InvoiceTypeEnum> qdInvoiceEnums() {
        return EnumSet.of(QS_INVOICE, QC_INVOICE);
    }

    public static List<String> qdInvoices() {
        return InvoiceTypeEnum.qdInvoiceEnums().stream().map(InvoiceTypeEnum::getResultCode).collect(Collectors.toList());
    }

    public static EnumSet<InvoiceTypeEnum> bpmsInvoiceEnums() {
        return EnumSet.of(SPECIAL_INVOICE, new InvoiceTypeEnum[]{GENERAL_INVOICE, ELECTRONIC_INVOICE, E_INVOICE, TOLLS_INVOICE, QC_INVOICE, QS_INVOICE});
    }

    public static List<String> bpmsInvoiceList() {
        return InvoiceTypeEnum.bpmsInvoiceEnums().stream().map(InvoiceTypeEnum::getResultCode).collect(Collectors.toList());
    }

    private InvoiceTypeEnum(String invoiceType, String resultCode, String resultTip) {
        this.invoiceType = invoiceType;
        this.resultCode = resultCode;
        this.resultTip = resultTip;
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public String getResultTip() {
        return this.resultTip;
    }
}

