/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

public class JsonResult<T>
implements Serializable {
    private static final long serialVersionUID = -9092995201221208352L;
    public static final String SUCCESS = "0";
    public static final String ERROR = "1";
    private String code;
    private String message;
    private T data;
    private int count;

    public JsonResult() {
    }

    public JsonResult(String code, String message) {
        this(code, message, null);
    }

    public JsonResult(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> JsonResult<T> ok() {
        return JsonResult.ok("\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> JsonResult<T> ok(String message) {
        return JsonResult.ok(SUCCESS, message);
    }

    public static <T> JsonResult<T> data(T data) {
        return new JsonResult<T>(SUCCESS, "\u64cd\u4f5c\u6210\u529f", data);
    }

    public static <T> JsonResult<T> ok(String code, String message) {
        return new JsonResult<T>(code, message);
    }

    public static <T> JsonResult<T> error() {
        return JsonResult.error("\u64cd\u4f5c\u5931\u8d25");
    }

    public static <T> JsonResult<T> error(String message) {
        return JsonResult.error(ERROR, message);
    }

    public static <T> JsonResult<T> error(String code, String message) {
        return JsonResult.ok(code, message);
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this != null && SUCCESS.equals(this.code);
    }

    @JsonIgnore
    public boolean isFail() {
        return !this.isSuccess();
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public int getCount() {
        return this.count;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonResult)) {
            return false;
        }
        JsonResult other = (JsonResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "JsonResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", count=" + this.getCount() + ")";
    }
}

