/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.ftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.xforceplus.evat.common.constant.consist.FtpConfigProperties;
import com.xforceplus.evat.common.utils.TraceUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FtpService {
    private static final Logger log = LoggerFactory.getLogger(FtpService.class);
    private ChannelSftp sftp = null;
    private Session session = null;
    private Channel channel = null;
    @Autowired
    private FtpConfigProperties ftpConfigProperties;

    public void closeChannel() {
        if (null != this.channel) {
            this.channel.disconnect();
        }
        if (null != this.session) {
            this.session.disconnect();
        }
        if (null != this.sftp) {
            this.sftp.disconnect();
        }
    }

    private void initFtpClient() throws JSchException {
        if (null != this.session && this.session.isConnected() || null != this.channel && this.channel.isConnected() || null != this.sftp && this.sftp.isConnected()) {
            this.closeChannel();
        }
        if (0 > this.ftpConfigProperties.getPort()) {
            this.ftpConfigProperties.setPort(22);
        }
        JSch jsch = new JSch();
        if (Objects.equals(this.ftpConfigProperties.getAuthMethod(), "private") && this.ftpConfigProperties.getPrivateKey() != null && !"".equals(this.ftpConfigProperties.getPrivateKey())) {
            if (this.ftpConfigProperties.getPassphrase() != null && "".equals(this.ftpConfigProperties.getPassphrase())) {
                jsch.addIdentity(this.ftpConfigProperties.getPrivateKey(), this.ftpConfigProperties.getPassphrase());
            } else {
                jsch.addIdentity(this.ftpConfigProperties.getPrivateKey());
            }
        }
        this.session = jsch.getSession(this.ftpConfigProperties.getUsername(), this.ftpConfigProperties.getHost(), this.ftpConfigProperties.getPort());
        if (Objects.equals(this.ftpConfigProperties.getAuthMethod(), "pwd") && this.ftpConfigProperties.getPassword() != null) {
            this.session.setPassword(this.ftpConfigProperties.getPassword());
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
        this.session.setConfig(config);
        this.session.setTimeout(Integer.parseInt(this.ftpConfigProperties.getTimeout()));
        this.session.connect();
        this.channel = this.session.openChannel("sftp");
        this.channel.connect();
        this.sftp = (ChannelSftp)this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String pathname, String fileName, InputStream inputStream) throws Exception {
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6,pathName={},fileName={}", (Object)pathname, (Object)fileName);
        this.initFtpClient();
        try {
            try {
                this.sftp.cd(pathname);
            }
            catch (SftpException e) {
                String[] dirs = pathname.split("/");
                String tempPath = "";
                for (String dir : dirs) {
                    if (null == dir || "".equals(dir)) continue;
                    tempPath = tempPath + "/" + dir;
                    try {
                        this.sftp.cd(tempPath);
                    }
                    catch (SftpException ex) {
                        this.sftp.mkdir(tempPath);
                        this.sftp.cd(tempPath);
                    }
                }
            }
            this.sftp.put(inputStream, fileName);
            inputStream.close();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\u3002");
            String string = this.sftp.pwd() + fileName;
            return string;
        }
        finally {
            this.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(String pathname, String fileName, MultipartFile file) throws Exception {
        TraceUtils.setTraceId(null);
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6,pathName={},fileName={}", (Object)pathname, (Object)file.getOriginalFilename());
        this.initFtpClient();
        try {
            try {
                this.sftp.cd(pathname);
            }
            catch (SftpException e) {
                String[] dirs = pathname.split("/");
                String tempPath = "";
                for (String dir : dirs) {
                    if (null == dir || "".equals(dir)) continue;
                    tempPath = tempPath + "/" + dir;
                    try {
                        this.sftp.cd(tempPath);
                    }
                    catch (SftpException ex) {
                        this.sftp.mkdir(tempPath);
                        this.sftp.cd(tempPath);
                    }
                }
            }
            InputStream inputStream = file.getInputStream();
            this.sftp.put(file.getInputStream(), fileName);
            inputStream.close();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\u3002");
        }
        finally {
            this.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFile(String directory, String fileName) throws Exception {
        TraceUtils.setTraceId(null);
        boolean succ = false;
        try {
            log.info("\u5f00\u59cb\u5220\u9664\u6587\u4ef6\uff0cdirectory={},fileName={}", (Object)directory, (Object)fileName);
            this.initFtpClient();
            if (directory != null && !"".equals(directory)) {
                this.sftp.cd(directory);
            }
            this.sftp.rm(fileName);
            succ = true;
            log.debug("\u5220\u9664\u6587\u4ef6\u6210\u529f!");
            boolean bl = succ;
            return bl;
        }
        finally {
            this.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String directory, String downloadFile, String saveFile) throws Exception {
        TraceUtils.setTraceId(null);
        boolean succ = false;
        try {
            String file;
            File fileLocal;
            log.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6\uff0cdirectory={},downloadFile={},saveFile={}", new Object[]{directory, downloadFile, saveFile});
            File filePath = new File(saveFile);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            this.initFtpClient();
            if (directory != null && !"".equals(directory)) {
                this.sftp.cd(directory);
            }
            if ((fileLocal = new File(file = saveFile + downloadFile)).exists()) {
                fileLocal.delete();
            }
            fileLocal.createNewFile();
            this.sftp.get(downloadFile, file);
            succ = true;
            log.debug("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f!");
            boolean bl = succ;
            return bl;
        }
        finally {
            this.closeChannel();
        }
    }

    @PreDestroy
    public void destroy() {
        this.closeChannel();
    }
}

