/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.invoice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.invoiceEntryAccount.EntryAccountRequest;
import com.xforceplus.evat.common.domain.invoiceEntryAccount.EntryAccountResponse;
import com.xforceplus.evat.common.domain.invoiceEntryAccount.EntryAccountResult;
import com.xforceplus.evat.common.modules.invoice.InvoiceEntryAccountService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceEntryAccountServiceImpl
implements InvoiceEntryAccountService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceEntryAccountServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult entryAccount(EntryAccountRequest request) {
        JanusRequest janusRequest = JanusRequest.builder().payLoadId(request.getInvoiceNo()).action(this.janusActionConfig.getEntryAccountAction()).tenantId(this.janusConfig.getTenantCode()).isValid(0).data(request).build();
        JsonResult jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
        if (jsonResult.isFail()) {
            log.info("<=== \u53d1\u8d77\u56fd\u7a0e\u53d1\u7968\u5165\u8d26\u5931\u8d25 \uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            return jsonResult;
        }
        String data = String.valueOf(jsonResult.getData());
        EntryAccountResponse entryAccountResponse = (EntryAccountResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<EntryAccountResponse<EntryAccountResponse.Result>>(){}, (Feature[])new Feature[0]);
        if (!entryAccountResponse.isOK()) {
            return JsonResult.error(entryAccountResponse.getCode() + "", entryAccountResponse.getMessage());
        }
        jsonResult = JsonResult.ok(entryAccountResponse.getMessage());
        jsonResult.setData(entryAccountResponse.getResult());
        return jsonResult;
    }

    @Override
    public JsonResult getEntryAccountResule(String taskId) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("taskId", taskId);
        JanusRequest janusRequest = JanusRequest.builder().payLoadId(taskId).action(this.janusActionConfig.getEntryAccountResuleAction()).tenantId(this.janusConfig.getTenantCode()).header(headerMap).isValid(0).build();
        JsonResult jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
        if (jsonResult.isFail()) {
            log.info("<=== \u53d1\u7968\u5165\u8d26\u83b7\u53d6\u7ed3\u679c\u5931\u8d25 \uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            return jsonResult;
        }
        String data = String.valueOf(jsonResult.getData());
        EntryAccountResult entryAccountResult = (EntryAccountResult)JSON.parseObject((String)data, (TypeReference)new TypeReference<EntryAccountResult<EntryAccountResult.Result>>(){}, (Feature[])new Feature[0]);
        if (!entryAccountResult.isOK()) {
            return JsonResult.error(entryAccountResult.getCode() + "", entryAccountResult.getMessage());
        }
        jsonResult = JsonResult.ok(entryAccountResult.getMessage());
        jsonResult.setData(entryAccountResult.getResult());
        return jsonResult;
    }
}

