/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.pdf.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicates;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.enums.SystemOrigEnum;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.pdfDiscern.DiscernRequest;
import com.xforceplus.evat.common.domain.pdfDiscern.DiscernResponse;
import com.xforceplus.evat.common.domain.pdfDiscern.DiscernResult;
import com.xforceplus.evat.common.modules.pdf.PdfDiscernService;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PdfDiscernServiceImpl
implements PdfDiscernService {
    private static final Logger log = LoggerFactory.getLogger(PdfDiscernServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;
    @Autowired
    private VerifyService verifyService;
    Retryer<Boolean> retryer = RetryerBuilder.newBuilder().retryIfException().retryIfRuntimeException().retryIfExceptionOfType(Exception.class).retryIfException(Predicates.equalTo((Object)new Exception())).retryIfResult(Predicates.equalTo((Object)false)).withWaitStrategy(WaitStrategies.randomWait((long)3L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)60L, (TimeUnit)TimeUnit.SECONDS)).build();

    @Override
    public JsonResult pdfDiscern(DiscernRequest discernRequest) {
        log.debug(">>>>>> discern info = {}", (Object)JacksonUtil.getInstance().toJson((Object)discernRequest));
        try {
            if (StringUtils.isBlank((CharSequence)discernRequest.getFile())) {
                return JsonResult.error("file\u53c2\u6570\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u3002");
            }
            boolean noneMatchOrig = Arrays.stream(SystemOrigEnum.values()).noneMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s.getSystemOrig(), (CharSequence)discernRequest.getSystemOrig()));
            if (noneMatchOrig) {
                return JsonResult.error("\u7cfb\u7edf\u6765\u6e90[systemOrig]\u5b57\u6bb5\u672a\u914d\u7f6e");
            }
            discernRequest.setTitle((String)StringUtils.defaultIfBlank((CharSequence)discernRequest.getTitle(), (CharSequence)"\u6c83\u5c14\u739b\u53d1\u7968\u8bc6\u522b"));
            discernRequest.setGroup((String)StringUtils.defaultIfBlank((CharSequence)discernRequest.getGroup(), (CharSequence)this.janusConfig.getTenantCode()));
            discernRequest.setScene((String)StringUtils.defaultIfBlank((CharSequence)discernRequest.getScene(), (CharSequence)"4"));
            discernRequest.setCallbackUrl((String)StringUtils.defaultIfBlank((CharSequence)discernRequest.getCallbackUrl(), (CharSequence)this.janusActionConfig.getDiscernCallbackUrl()));
            discernRequest.setFileSuffix((String)StringUtils.defaultIfBlank((CharSequence)discernRequest.getFileSuffix(), (CharSequence)".pdf"));
            discernRequest.setCustomerNo(this.janusConfig.getTcp().getCustomerNo());
            String gZipFile = CommonUtils.gzip(discernRequest.getFile());
            discernRequest.setFile(gZipFile);
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(discernRequest.getSerialNo()).action(this.janusActionConfig.getDiscern()).tenantId(this.janusConfig.getTenantCode()).isValid(0).data(discernRequest).build();
            JsonResult jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            if (jsonResult.isFail()) {
                log.info("<=== PDF\u6587\u4ef6\u8bc6\u522b\u8bf7\u6c42\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            DiscernResponse discernResponse = (DiscernResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<DiscernResponse<DiscernResponse.Result>>(){}, (Feature[])new Feature[0]);
            if (!discernResponse.isOK()) {
                return JsonResult.error(discernResponse.getCode() + "", discernResponse.getMessage());
            }
            jsonResult = JsonResult.ok(discernResponse.getMessage());
            jsonResult.setData(discernResponse.getResult());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("PDF\u6587\u4ef6\u8bc6\u522b\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult pdfDiscernSync(DiscernRequest discernRequest) {
        JsonResult jsonResult = this.pdfDiscern(discernRequest);
        if (jsonResult.isFail()) {
            return jsonResult;
        }
        DiscernResponse.Result result = (DiscernResponse.Result)jsonResult.getData();
        String taskId = result.getTaskId();
        JsonResult queryJsonResult = this.pdfDiscernQuerySync(taskId);
        return queryJsonResult;
    }

    @Override
    public JsonResult pdfDiscernQuery(String taskIds) {
        log.debug(">>>>>> discern query info = {}", (Object)JacksonUtil.getInstance().toJson((Object)taskIds));
        try {
            if (StringUtils.isBlank((CharSequence)taskIds)) {
                return JsonResult.error("taskIds\u53c2\u6570\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u3002");
            }
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("taskIds", taskIds);
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(taskIds).action(this.janusActionConfig.getDiscernQuery()).tenantId(this.janusConfig.getTenantCode()).header(headerMap).isValid(0).build();
            JsonResult jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
            if (jsonResult.isFail()) {
                log.info("<=== \u83b7\u53d6PDF\u8bc6\u522b\u7ed3\u679c\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            DiscernResponse discernResponse = (DiscernResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<DiscernResponse<List<DiscernResult>>>(){}, (Feature[])new Feature[0]);
            if (!discernResponse.isOK()) {
                return JsonResult.error(discernResponse.getCode() + "", discernResponse.getMessage());
            }
            jsonResult = JsonResult.ok(discernResponse.getMessage());
            jsonResult.setData(discernResponse.getResult());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6PDF\u8bc6\u522b\u7ed3\u679c\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult pdfDiscernQuerySync(String taskIds) {
        JsonResult jsonResult = JsonResult.error();
        try {
            TimeUnit.SECONDS.sleep(2L);
            Callable<Boolean> callable = () -> {
                try {
                    JsonResult _jsonResult = this.pdfDiscernQuery(taskIds);
                    jsonResult.setCode(_jsonResult.getCode());
                    jsonResult.setMessage(_jsonResult.getMessage());
                    if (_jsonResult.isFail()) {
                        return false;
                    }
                    List cognitionResponseList = (List)_jsonResult.getData();
                    if (cognitionResponseList.isEmpty()) {
                        return false;
                    }
                    DiscernResult cognitionResponse = (DiscernResult)cognitionResponseList.get(0);
                    int discernStatus = cognitionResponse.getDiscernStatus();
                    if (discernStatus == 0 || discernStatus == 3) {
                        jsonResult.setMessage("\u83b7\u53d6\u7ed3\u679c\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5b8c\u6210\u3002");
                        return false;
                    }
                    jsonResult.setCode("0");
                    jsonResult.setData(cognitionResponse);
                    return true;
                }
                catch (Exception e) {
                    log.error("error={}", (Throwable)e);
                    jsonResult.setMessage(e.getMessage());
                    return false;
                }
            };
            this.retryer.call(callable);
        }
        catch (RetryException e) {
            jsonResult.setCode("1");
            jsonResult.setMessage("\u83b7\u53d6\u89e3\u6790\u7ed3\u679c\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            log.error("error={}", (Object)e.getMessage());
        }
        catch (Exception e) {
            jsonResult.setCode("1");
            jsonResult.setMessage("\u83b7\u53d6\u89e3\u6790\u7ed3\u679c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            log.error("error={}", (Object)e.getMessage());
        }
        return jsonResult;
    }
}

