/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.verify.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.enums.InvoiceTypeEnum;
import com.xforceplus.evat.common.constant.enums.SystemOrigEnum;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdResponse;
import com.xforceplus.evat.common.domain.verify.InvoiceDetail;
import com.xforceplus.evat.common.domain.verify.InvoiceMain;
import com.xforceplus.evat.common.modules.verify.OfdService;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfdServiceImpl
implements OfdService {
    private static final Logger log = LoggerFactory.getLogger(OfdServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;
    @Autowired
    private VerifyService verifyService;

    @Override
    public JsonResult analysisOfd(AnalysisOfdRequest analysisOfdRequest) {
        log.debug(">>>>>> analysisOfd info = {}", (Object)JacksonUtil.getInstance().toJson((Object)analysisOfdRequest));
        try {
            if (StringUtils.isBlank((CharSequence)analysisOfdRequest.getOfdEncode())) {
                return JsonResult.error("ofdEncode\u53c2\u6570\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u3002");
            }
            boolean noneMatchOrig = Arrays.stream(SystemOrigEnum.values()).noneMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s.getSystemOrig(), (CharSequence)analysisOfdRequest.getSystemOrig()));
            if (noneMatchOrig) {
                return JsonResult.error("\u7cfb\u7edf\u6765\u6e90[systemOrig]\u5b57\u6bb5\u672a\u914d\u7f6e");
            }
            analysisOfdRequest.setTenantCode((String)StringUtils.defaultIfBlank((CharSequence)analysisOfdRequest.getTenantCode(), (CharSequence)this.janusConfig.getTenantCode()));
            analysisOfdRequest.setType((String)StringUtils.defaultIfBlank((CharSequence)analysisOfdRequest.getType(), (CharSequence)"1"));
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(analysisOfdRequest.getSerialNo()).action(this.janusActionConfig.getOfdDiscern()).tenantId(this.janusConfig.getTenantCode()).isValid(0).data(analysisOfdRequest).build();
            JsonResult<AnalysisOfdResponse.OfdResponseResult> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            if (jsonResult.isFail()) {
                log.info("<=== OFD\u6587\u4ef6\u89e3\u6790\u8bf7\u6c42\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            AnalysisOfdResponse analysisOfdResponse = (AnalysisOfdResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<AnalysisOfdResponse>(){}, (Feature[])new Feature[0]);
            if (!analysisOfdResponse.isOk()) {
                return JsonResult.error(analysisOfdResponse.getCode() + "", analysisOfdResponse.getMessage());
            }
            jsonResult = JsonResult.ok(analysisOfdResponse.getMessage());
            this.analysisOfdHandle(analysisOfdResponse.getResult());
            jsonResult.setData(analysisOfdResponse.getResult());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("OFD\u6587\u4ef6\u89e3\u6790\u8bf7\u6c42\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    public void analysisOfdHandle(AnalysisOfdResponse.OfdResponseResult ofdResponseResult) {
        if (ofdResponseResult == null || ofdResponseResult.getInvoiceMain() == null) {
            return;
        }
        InvoiceMain invoiceMain = ofdResponseResult.getInvoiceMain();
        String resultCode = InvoiceTypeEnum.getResultCode(invoiceMain.getInvoiceType()).orElse("");
        invoiceMain.setInvoiceType(resultCode);
        String invoiceCode = StringUtils.equalsAny((CharSequence)invoiceMain.getInvoiceCode(), (CharSequence[])new CharSequence[]{"\u5168\u7535\u53d1\u7968", "\u6570\u7535\u7968"}) ? "" : invoiceMain.getInvoiceCode();
        invoiceMain.setInvoiceCode(invoiceCode);
        List<InvoiceDetail> invoiceDetails = ofdResponseResult.getInvoiceDetails();
        invoiceDetails.forEach(s -> CommonUtils.taxRateHandle(s.getTaxRate()).ifPresent(taxRate -> s.setTaxRate(taxRate.stripTrailingZeros().toPlainString())));
    }
}

