/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    static final String DEFAULT_CHARSET = "UTF-8";
    static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    static final int DEFAULT_CONNECT_TIMEOU = 30000;
    static final String isProxy = "false";
    static final String host = "";
    static final String port = "";

    public static String get(String url) {
        return HttpClientUtils.httpGet(url, null, null, DEFAULT_CHARSET, HttpClientUtils.getIsProxy());
    }

    public static byte[] getFileInputStream(String url) {
        return HttpClientUtils.httpGetFileInputStream(url, null, null, DEFAULT_CHARSET, HttpClientUtils.getIsProxy());
    }

    public static String get(String url, Map<String, String> header, Map<String, String> params) {
        return HttpClientUtils.httpGet(url, params, header, DEFAULT_CHARSET, HttpClientUtils.getIsProxy());
    }

    public static String get(String url, Map<String, String> params) {
        return HttpClientUtils.httpGet(url, params, null, DEFAULT_CHARSET, HttpClientUtils.getIsProxy());
    }

    public static String post(String url, Map<String, String> params) {
        return HttpClientUtils.httpPost(url, params, null, DEFAULT_CHARSET, HttpClientUtils.getIsProxy());
    }

    public static String postJson(String url, String jsonParams) {
        return HttpClientUtils.httpPostJson(url, jsonParams, null, DEFAULT_CHARSET, HttpClientUtils.getIsProxy());
    }

    public static String postJson(String url, String jsonParams, Map<String, String> header) {
        return HttpClientUtils.httpPostJson(url, jsonParams, header, DEFAULT_CHARSET, HttpClientUtils.getIsProxy());
    }

    private static boolean getIsProxy() {
        if (StringUtils.isBlank((CharSequence)isProxy)) {
            return false;
        }
        return Boolean.parseBoolean(isProxy);
    }

    private static RequestConfig getRequestConfig(boolean isProxy) {
        if (isProxy && StringUtils.isNotBlank((CharSequence)"") && StringUtils.isNotBlank((CharSequence)"")) {
            logger.info("HttpURLConnectionUtils set proxy host:{},port:{}", (Object)"", (Object)"");
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setSocketTimeout(30000).setConnectTimeout(30000);
        if (isProxy && StringUtils.isNotBlank((CharSequence)"") && StringUtils.isNotBlank((CharSequence)"")) {
            builder.setProxy(new HttpHost("", Integer.parseInt("")));
        }
        return builder.build();
    }

    public static String fileDownloadByHttp(String fileUrl) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            return "";
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(fileUrl).openConnection();
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = connection.getInputStream();
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = inputStream.read(buff, 0, 1024)) > 0) {
            swapStream.write(buff, 0, len);
        }
        return Base64.encodeBase64String((byte[])swapStream.toByteArray());
    }

    public static String httpPost(String url, Map<String, String> params, Map<String, String> header, String charset, boolean isProxy) {
        String string;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpPost httpPost = null;
        try {
            httpClient = HttpClientUtils.getCloseableHttpClient(url);
            httpPost = new HttpPost(url);
            httpPost.setConfig(HttpClientUtils.getRequestConfig(isProxy));
            ArrayList<BasicNameValuePair> listParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                listParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            if (header != null && header.size() > 0) {
                for (String key : header.keySet()) {
                    httpPost.setHeader(key, header.get(key));
                }
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(listParams, charset));
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(String.format("request %s error,status: %s,msg\uff1a%s", url, response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset)));
            }
            string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeHttp(httpClient, response, httpPost, null);
                throw throwable;
            }
        }
        HttpClientUtils.closeHttp(httpClient, response, httpPost, null);
        return string;
    }

    public static String httpPostJson(String url, String jsonParams, Map<String, String> header, String charset, boolean isProxy) {
        String string;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpPost httpPost = null;
        try {
            httpClient = HttpClientUtils.getCloseableHttpClient(url);
            httpPost = new HttpPost(url);
            httpPost.setConfig(HttpClientUtils.getRequestConfig(isProxy));
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            if (header != null && header.size() > 0) {
                for (String key : header.keySet()) {
                    httpPost.setHeader(key, header.get(key));
                }
            }
            StringEntity stringEntity = new StringEntity(jsonParams, ContentType.APPLICATION_JSON);
            stringEntity.setContentEncoding(charset);
            httpPost.setEntity((HttpEntity)new StringEntity(jsonParams, ContentType.APPLICATION_JSON));
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(String.format("request json %s error,status: %s,msg\uff1a%s", url, response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset)));
            }
            string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeHttp(httpClient, response, httpPost, null);
                throw throwable;
            }
        }
        HttpClientUtils.closeHttp(httpClient, response, httpPost, null);
        return string;
    }

    public static byte[] httpGetFileInputStream(String url, Map<String, String> param, Map<String, String> header, String charset, boolean isProxy) {
        byte[] byArray;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        ByteArrayOutputStream swapStream = null;
        try {
            httpClient = HttpClientUtils.getCloseableHttpClient(url);
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            httpGet = new HttpGet(builder.build());
            if (header != null && header.size() > 0) {
                for (String key : header.keySet()) {
                    httpGet.setHeader(key, header.get(key));
                }
            }
            httpGet.setConfig(HttpClientUtils.getRequestConfig(isProxy));
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(String.format("request %s error,status: %s,msg\uff1a%s", url, response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset)));
            }
            InputStream inputStream = response.getEntity().getContent();
            swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buff, 0, 1024)) > 0) {
                swapStream.write(buff, 0, len);
            }
            byArray = swapStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeHttp(httpClient, response, null, httpGet);
                if (swapStream != null) {
                    try {
                        swapStream.close();
                    }
                    catch (IOException e2) {
                        logger.warn("httpGetFileInputStream ByteArrayOutputStream close error", (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
        HttpClientUtils.closeHttp(httpClient, response, null, httpGet);
        if (swapStream != null) {
            try {
                swapStream.close();
            }
            catch (IOException e) {
                logger.warn("httpGetFileInputStream ByteArrayOutputStream close error", (Throwable)e);
            }
        }
        return byArray;
    }

    public static String httpGet(String url, Map<String, String> param, Map<String, String> header, String charset, boolean isProxy) {
        String string;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        try {
            httpClient = HttpClientUtils.getCloseableHttpClient(url);
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            httpGet = new HttpGet(builder.build());
            if (header != null && header.size() > 0) {
                for (String key : header.keySet()) {
                    httpGet.setHeader(key, header.get(key));
                }
            }
            httpGet.setConfig(HttpClientUtils.getRequestConfig(isProxy));
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(String.format("request %s error,status: %s,msg\uff1a%s", url, response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset)));
            }
            string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeHttp(httpClient, response, null, httpGet);
                throw throwable;
            }
        }
        HttpClientUtils.closeHttp(httpClient, response, null, httpGet);
        return string;
    }

    private static CloseableHttpClient getCloseableHttpClient(String url) throws KeyManagementException, KeyStoreException, NoSuchAlgorithmException {
        CloseableHttpClient httpClient = null;
        httpClient = url.startsWith("https:") ? HttpClientUtils.getHttpsClient() : HttpClients.createDefault();
        return httpClient;
    }

    private static void closeHttp(CloseableHttpClient httpClient, CloseableHttpResponse response, HttpPost httpPost, HttpGet httpGet) {
        if (httpGet != null) {
            httpGet.releaseConnection();
        }
        if (httpPost != null) {
            httpPost.releaseConnection();
        }
        try {
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                response.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static CloseableHttpClient getHttpsClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("standard").setConnectionRequestTimeout(10000).setConnectTimeout(30000).setSocketTimeout(30000).build();
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                return true;
            }
        });
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)HttpClientUtils.trustAllHttpsCertificates()).build();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(200);
        HttpClientBuilder custom = HttpClients.custom();
        custom.setDefaultRequestConfig(globalConfig);
        custom.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        custom.setConnectionManager((HttpClientConnectionManager)manager);
        custom.setConnectionManagerShared(true);
        return custom.build();
    }

    private static SSLConnectionSocketFactory trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }
}

