/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.configuration;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.codec.SnappyCodecV2;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedissonClientConfiguration.class);

    @Bean
    public RedissonClient redissonClient(RedisProperties redisProperties) {
        if (redisProperties.getSentinel() != null) {
            return this.redissonSentinelClient(redisProperties);
        }
        if (redisProperties.getCluster() != null) {
            return this.redissonClusterClient(redisProperties);
        }
        return this.redissonSingleClient(redisProperties);
    }

    private RedissonClient redissonClusterClient(RedisProperties redisProperties) {
        Config config = new Config();
        ClusterServersConfig clusterServersConfig = config.useClusterServers();
        ArrayList<String> clusterNodes = new ArrayList<String>();
        log.info("redis cluster url:{}", (Object)JSON.toJSONString((Object)redisProperties.getCluster().getNodes()));
        for (int i = 0; i < redisProperties.getCluster().getNodes().size(); ++i) {
            clusterNodes.add(String.format("redis://%s", redisProperties.getCluster().getNodes().get(i)));
        }
        clusterServersConfig.addNodeAddress(clusterNodes.toArray(new String[0]));
        if (StringUtils.isNotBlank((CharSequence)redisProperties.getPassword())) {
            clusterServersConfig.setPassword(redisProperties.getPassword());
        }
        clusterServersConfig.setTcpNoDelay(true);
        config.setCodec((Codec)new SnappyCodecV2((Codec)new JsonJacksonCodec()));
        config.setNettyThreads(32);
        return Redisson.create((Config)config);
    }

    private RedissonClient redissonSentinelClient(RedisProperties redisProperties) {
        Config config = new Config();
        SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
        sentinelServersConfig.setMasterName(redisProperties.getSentinel().getMaster());
        ArrayList<String> sentinelAddresses = new ArrayList<String>();
        for (int i = 0; i < redisProperties.getSentinel().getNodes().size(); ++i) {
            sentinelAddresses.add(String.format("redis://%s", redisProperties.getSentinel().getNodes().get(i)));
        }
        sentinelServersConfig.addSentinelAddress(sentinelAddresses.toArray(new String[sentinelAddresses.size()]));
        sentinelServersConfig.setDatabase(redisProperties.getDatabase());
        if (StringUtils.isNotBlank((CharSequence)redisProperties.getPassword())) {
            sentinelServersConfig.setPassword(redisProperties.getPassword());
        }
        sentinelServersConfig.setTcpNoDelay(true);
        config.setCodec((Codec)new SnappyCodecV2((Codec)new JsonJacksonCodec()));
        config.setNettyThreads(32);
        return Redisson.create((Config)config);
    }

    private RedissonClient redissonSingleClient(RedisProperties redisProperties) {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress(String.format("redis://%s:%s", redisProperties.getHost(), redisProperties.getPort()));
        if (StringUtils.isNotBlank((CharSequence)redisProperties.getPassword())) {
            singleServerConfig.setPassword(redisProperties.getPassword());
        }
        singleServerConfig.setDatabase(redisProperties.getDatabase());
        singleServerConfig.setTcpNoDelay(true);
        config.setCodec((Codec)new SnappyCodecV2((Codec)new JsonJacksonCodec()));
        config.setNettyThreads(32);
        return Redisson.create((Config)config);
    }
}

