/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.redLetter.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.enums.SystemOrigEnum;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.redLetter.ApplyConfirmationSheetQuery;
import com.xforceplus.evat.common.domain.redLetter.ApplyConfirmationSheetQueryRedLetter;
import com.xforceplus.evat.common.domain.redLetter.ApplyConfirmationSheetResult;
import com.xforceplus.evat.common.domain.redLetter.ConfirmationSheetResponse;
import com.xforceplus.evat.common.domain.redLetter.OperateConfirmationSheetQuery;
import com.xforceplus.evat.common.modules.redLetter.ConfirmationSheetService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfirmationSheetServiceImpl
implements ConfirmationSheetService {
    private static final Logger log = LoggerFactory.getLogger(ConfirmationSheetServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult applyConfirmationSheet(ApplyConfirmationSheetQuery applyConfirmationSheetQuery) {
        log.debug(">>>>>> \u7ea2\u5b57\u786e\u8ba4\u5355\u7533\u8bf7 upload info = {}", (Object)JacksonUtil.getInstance().toJson((Object)applyConfirmationSheetQuery));
        try {
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            boolean noneMatchOrig = Arrays.stream(SystemOrigEnum.values()).noneMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s.getSystemOrig(), (CharSequence)applyConfirmationSheetQuery.getSystemOrig()));
            if (noneMatchOrig) {
                return JsonResult.error("\u7cfb\u7edf\u6765\u6e90[systemOrig]\u5b57\u6bb5\u672a\u914d\u7f6e");
            }
            List<ApplyConfirmationSheetQueryRedLetter> redLetters = applyConfirmationSheetQuery.getRedLetters();
            ApplyConfirmationSheetQueryRedLetter redLetter = redLetters.get(0);
            JanusRequest janusRequest = JanusRequest.builder().build();
            String payLoadId = MessageFormat.format("{0}{1}", StringUtils.isEmpty((CharSequence)redLetter.getOriginalAllElectricInvoiceNo()) ? "" : redLetter.getOriginalAllElectricInvoiceNo(), StringUtils.isEmpty((CharSequence)redLetter.getOriginalInvoiceNo()) ? "" : redLetter.getOriginalInvoiceNo());
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("version", this.janusConfig.getTenantCode());
            janusRequest.setPayLoadId(payLoadId);
            janusRequest.setAction(this.janusActionConfig.getRedConfirmationApply());
            janusRequest.setData(JSONObject.toJSONString((Object)applyConfirmationSheetQuery));
            janusRequest.setHeader(heaserMap);
            janusRequest.setDataType("JSON");
            JsonResult<ConfirmationSheetResponse.Result> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< \u7ea2\u5b57\u786e\u8ba4\u5355\u7533\u8bf7 result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            ApplyConfirmationSheetResult applyConfirmationSheetResult = new ApplyConfirmationSheetResult();
            applyConfirmationSheetResult.getOriginalInvoiceType();
            applyConfirmationSheetResult.getApplyStatus();
            String data = String.valueOf(jsonResult.getData());
            ConfirmationSheetResponse confirmationSheetResponse = (ConfirmationSheetResponse)JSON.parseObject((String)data, ConfirmationSheetResponse.class);
            if (!confirmationSheetResponse.isOK()) {
                return JsonResult.error(confirmationSheetResponse.getCode(), confirmationSheetResponse.getMessage());
            }
            jsonResult = JsonResult.ok(confirmationSheetResponse.getMessage());
            ConfirmationSheetResponse.Result result = confirmationSheetResponse.getResult();
            jsonResult.setData(result);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u7ea2\u5b57\u786e\u8ba4\u5355\u7533\u8bf7 request error ", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult operateConfirmationSheet(OperateConfirmationSheetQuery operateConfirmationSheetQuery) {
        log.debug(">>>>>> \u7ea2\u5b57\u786e\u8ba4\u5355\u64cd\u4f5c upload info = {}", (Object)JacksonUtil.getInstance().toJson((Object)operateConfirmationSheetQuery));
        try {
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            boolean noneMatchOrig = Arrays.stream(SystemOrigEnum.values()).noneMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s.getSystemOrig(), (CharSequence)operateConfirmationSheetQuery.getSystemOrig()));
            if (noneMatchOrig) {
                return JsonResult.error("\u7cfb\u7edf\u6765\u6e90[systemOrig]\u5b57\u6bb5\u672a\u914d\u7f6e");
            }
            JanusRequest janusRequest = JanusRequest.builder().build();
            String payLoadId = MessageFormat.format("{0}{1}", StringUtils.isEmpty((CharSequence)operateConfirmationSheetQuery.getOriginalAllElectricInvoiceNo()) ? "" : operateConfirmationSheetQuery.getOriginalAllElectricInvoiceNo(), StringUtils.isEmpty((CharSequence)operateConfirmationSheetQuery.getOriginalInvoiceNo()) ? "" : operateConfirmationSheetQuery.getOriginalInvoiceNo());
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("version", this.janusConfig.getTenantCode());
            janusRequest.setPayLoadId(payLoadId);
            janusRequest.setAction(this.janusActionConfig.getRedConfirmationOperate());
            janusRequest.setData(operateConfirmationSheetQuery);
            janusRequest.setHeader(heaserMap);
            janusRequest.setDataType("JSON");
            JsonResult<ConfirmationSheetResponse.Result> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< \u7ea2\u5b57\u786e\u8ba4\u5355\u64cd\u4f5c result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            ConfirmationSheetResponse confirmationSheetResponse = (ConfirmationSheetResponse)JSON.parseObject((String)data, ConfirmationSheetResponse.class);
            if (!confirmationSheetResponse.isOK()) {
                return JsonResult.error(confirmationSheetResponse.getCode(), confirmationSheetResponse.getMessage());
            }
            jsonResult = JsonResult.ok(confirmationSheetResponse.getMessage());
            ConfirmationSheetResponse.Result result = confirmationSheetResponse.getResult();
            jsonResult.setData(result);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u7ea2\u5b57\u786e\u8ba4\u5355\u64cd\u4f5c request error ", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }
}

