/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.codec.Base64Encoder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);

    public static String gzip(byte[] file) {
        String base64Str = Base64Encoder.encode((byte[])Objects.requireNonNull(file));
        return CommonUtils.gzip(base64Str);
    }

    public static String gzip(String fileBase64) {
        GZIPOutputStream gzip = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            gzip.write(fileBase64.getBytes());
            gzip.close();
            return Base64Encoder.encode((byte[])Objects.requireNonNull(out.toByteArray()));
        }
        catch (Exception e) {
            log.error("\u5b57\u7b26\u4e32\u538b\u7f29\u5f02\u5e38:", (Throwable)e);
            return "";
        }
    }

    public static String uncompress(String gzipBase64) {
        if (StringUtils.isBlank((CharSequence)gzipBase64)) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(Base64Decoder.decode((CharSequence)gzipBase64));
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            log.error("\u5b57\u7b26\u4e32\u89e3\u538b\u7f29\u5f02\u5e38:", (Throwable)e);
        }
        return Base64Encoder.encode((byte[])out.toByteArray());
    }

    public static String genUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String strSecurityFilter(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("../", "").replaceAll("..\\\\", "").replaceAll("\\*", "");
    }

    public static Optional<BigDecimal> taxRateHandle(String taxRateStr) {
        if (StringUtils.isBlank((CharSequence)taxRateStr)) {
            return Optional.empty();
        }
        try {
            taxRateStr = StringUtils.replace((String)taxRateStr, (String)"%", (String)"");
            BigDecimal taxRate = new BigDecimal(taxRateStr);
            if (BigDecimal.ONE.compareTo(taxRate) > 0) {
                taxRate = taxRate.movePointRight(2);
            }
            return Optional.of(taxRate);
        }
        catch (Exception e) {
            log.error("error=", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static String amountToStr(BigDecimal bigDecimal) {
        return CommonUtils.amountToStr(bigDecimal, 2);
    }

    public static String amountToStr(BigDecimal bigDecimal, int newScale) {
        return Optional.ofNullable(bigDecimal).map(s -> bigDecimal.setScale(newScale, RoundingMode.HALF_UP).toPlainString()).orElse("");
    }

    public static Boolean isQuanDian(String invoiceNo) {
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            return false;
        }
        if (invoiceNo.length() == 20 && !StringUtils.equals((CharSequence)invoiceNo.substring(0, 7), (CharSequence)"0000000")) {
            return true;
        }
        return false;
    }

    public static Optional<String> getHostInvWeb(String hostInvNo) {
        if (StringUtils.isBlank((CharSequence)hostInvNo)) {
            return Optional.empty();
        }
        String prefix = hostInvNo.substring(0, 7);
        if (hostInvNo.length() > 14 && !StringUtils.equals((CharSequence)prefix, (CharSequence)"0000000")) {
            String hostInv = hostInvNo.substring(1, 15);
            log.info("HOST\u7cfb\u7edf\u53d1\u7968\u53f7\u7801:{} to hostInv:{}", (Object)hostInvNo, (Object)hostInv);
            return Optional.of(hostInv);
        }
        return Optional.empty();
    }

    public static Optional<String> getHostInv(String hostInvNo) {
        if (StringUtils.isBlank((CharSequence)hostInvNo)) {
            return Optional.empty();
        }
        int length = StringUtils.length((CharSequence)hostInvNo);
        if (length == 20 && !hostInvNo.startsWith("0")) {
            return Optional.of(hostInvNo);
        }
        if (hostInvNo.startsWith("000000000000")) {
            return Optional.of(hostInvNo.substring(length - 8, length));
        }
        if (hostInvNo.startsWith("000000")) {
            return Optional.of(hostInvNo.substring(length - 14, length));
        }
        if (hostInvNo.startsWith("00000")) {
            return Optional.of(hostInvNo.substring(length - 15, length));
        }
        return Optional.empty();
    }

    public static String getGoodsName(String goodsName) {
        if (StringUtils.isBlank((CharSequence)goodsName)) {
            return "";
        }
        String regEx = "^\\*[\\s\\S]{1,99}\\*[\\s\\S]{1,99}$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(goodsName);
        if (matcher.matches()) {
            goodsName = goodsName.substring(goodsName.indexOf("*", goodsName.indexOf("*") + 1) + 1);
        }
        return goodsName;
    }

    public static BigDecimal toBigDecimal(String str, BigDecimal defaultValue) {
        try {
            return NumberUtils.createBigDecimal((String)str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) {
        if (map == null) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object obj = objectMapper.convertValue(map, beanClass);
        return obj;
    }
}

