/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.domain;

import com.xforceplus.evat.common.constant.enums.SystemOrigEnum;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ExternalConfig.class})
@ConfigurationProperties(prefix="evat.external")
public class ExternalConfig {
    private CommonConfig common = new CommonConfig();
    private Map<String, SystemConfig> system = new HashMap<String, SystemConfig>();

    public String getFlowTypeByBusinessSource(SystemOrigEnum systemOrigEnum) {
        return this.system.get(systemOrigEnum.getPathCode()).getVerifyFeedBackUrl();
    }

    public CommonConfig getCommon() {
        return this.common;
    }

    public Map<String, SystemConfig> getSystem() {
        return this.system;
    }

    public void setCommon(CommonConfig common) {
        this.common = common;
    }

    public void setSystem(Map<String, SystemConfig> system) {
        this.system = system;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalConfig)) {
            return false;
        }
        ExternalConfig other = (ExternalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonConfig this$common = this.getCommon();
        CommonConfig other$common = other.getCommon();
        if (this$common == null ? other$common != null : !((Object)this$common).equals(other$common)) {
            return false;
        }
        Map<String, SystemConfig> this$system = this.getSystem();
        Map<String, SystemConfig> other$system = other.getSystem();
        return !(this$system == null ? other$system != null : !((Object)this$system).equals(other$system));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonConfig $common = this.getCommon();
        result = result * 59 + ($common == null ? 43 : ((Object)$common).hashCode());
        Map<String, SystemConfig> $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : ((Object)$system).hashCode());
        return result;
    }

    public String toString() {
        return "ExternalConfig(common=" + this.getCommon() + ", system=" + this.getSystem() + ")";
    }

    public static class BaseSystemConfig {
        private String verifyFeedBackUrl;

        public String getVerifyFeedBackUrl() {
            return this.verifyFeedBackUrl;
        }

        public void setVerifyFeedBackUrl(String verifyFeedBackUrl) {
            this.verifyFeedBackUrl = verifyFeedBackUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseSystemConfig)) {
                return false;
            }
            BaseSystemConfig other = (BaseSystemConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$verifyFeedBackUrl = this.getVerifyFeedBackUrl();
            String other$verifyFeedBackUrl = other.getVerifyFeedBackUrl();
            return !(this$verifyFeedBackUrl == null ? other$verifyFeedBackUrl != null : !this$verifyFeedBackUrl.equals(other$verifyFeedBackUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaseSystemConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $verifyFeedBackUrl = this.getVerifyFeedBackUrl();
            result = result * 59 + ($verifyFeedBackUrl == null ? 43 : $verifyFeedBackUrl.hashCode());
            return result;
        }

        public String toString() {
            return "ExternalConfig.BaseSystemConfig(verifyFeedBackUrl=" + this.getVerifyFeedBackUrl() + ")";
        }
    }

    public static class SystemConfig
    extends BaseSystemConfig {
        private String bmsTaxBillFeedbackUrl;
        private String bmsQueryTaxBillUrl;
        private String bmsInvoiceReceiptUrl;

        public String getBmsTaxBillFeedbackUrl() {
            return this.bmsTaxBillFeedbackUrl;
        }

        public String getBmsQueryTaxBillUrl() {
            return this.bmsQueryTaxBillUrl;
        }

        public String getBmsInvoiceReceiptUrl() {
            return this.bmsInvoiceReceiptUrl;
        }

        public void setBmsTaxBillFeedbackUrl(String bmsTaxBillFeedbackUrl) {
            this.bmsTaxBillFeedbackUrl = bmsTaxBillFeedbackUrl;
        }

        public void setBmsQueryTaxBillUrl(String bmsQueryTaxBillUrl) {
            this.bmsQueryTaxBillUrl = bmsQueryTaxBillUrl;
        }

        public void setBmsInvoiceReceiptUrl(String bmsInvoiceReceiptUrl) {
            this.bmsInvoiceReceiptUrl = bmsInvoiceReceiptUrl;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SystemConfig)) {
                return false;
            }
            SystemConfig other = (SystemConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bmsTaxBillFeedbackUrl = this.getBmsTaxBillFeedbackUrl();
            String other$bmsTaxBillFeedbackUrl = other.getBmsTaxBillFeedbackUrl();
            if (this$bmsTaxBillFeedbackUrl == null ? other$bmsTaxBillFeedbackUrl != null : !this$bmsTaxBillFeedbackUrl.equals(other$bmsTaxBillFeedbackUrl)) {
                return false;
            }
            String this$bmsQueryTaxBillUrl = this.getBmsQueryTaxBillUrl();
            String other$bmsQueryTaxBillUrl = other.getBmsQueryTaxBillUrl();
            if (this$bmsQueryTaxBillUrl == null ? other$bmsQueryTaxBillUrl != null : !this$bmsQueryTaxBillUrl.equals(other$bmsQueryTaxBillUrl)) {
                return false;
            }
            String this$bmsInvoiceReceiptUrl = this.getBmsInvoiceReceiptUrl();
            String other$bmsInvoiceReceiptUrl = other.getBmsInvoiceReceiptUrl();
            return !(this$bmsInvoiceReceiptUrl == null ? other$bmsInvoiceReceiptUrl != null : !this$bmsInvoiceReceiptUrl.equals(other$bmsInvoiceReceiptUrl));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof SystemConfig;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bmsTaxBillFeedbackUrl = this.getBmsTaxBillFeedbackUrl();
            result = result * 59 + ($bmsTaxBillFeedbackUrl == null ? 43 : $bmsTaxBillFeedbackUrl.hashCode());
            String $bmsQueryTaxBillUrl = this.getBmsQueryTaxBillUrl();
            result = result * 59 + ($bmsQueryTaxBillUrl == null ? 43 : $bmsQueryTaxBillUrl.hashCode());
            String $bmsInvoiceReceiptUrl = this.getBmsInvoiceReceiptUrl();
            result = result * 59 + ($bmsInvoiceReceiptUrl == null ? 43 : $bmsInvoiceReceiptUrl.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "ExternalConfig.SystemConfig(bmsTaxBillFeedbackUrl=" + this.getBmsTaxBillFeedbackUrl() + ", bmsQueryTaxBillUrl=" + this.getBmsQueryTaxBillUrl() + ", bmsInvoiceReceiptUrl=" + this.getBmsInvoiceReceiptUrl() + ")";
        }
    }

    public static class CommonConfig {
        private String host;
        private String appKey;
        private String version;
        private String format;

        public String getHost() {
            return this.host;
        }

        public String getAppKey() {
            return this.appKey;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFormat() {
            return this.format;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommonConfig)) {
                return false;
            }
            CommonConfig other = (CommonConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$appKey = this.getAppKey();
            String other$appKey = other.getAppKey();
            if (this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommonConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $appKey = this.getAppKey();
            result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }

        public String toString() {
            return "ExternalConfig.CommonConfig(host=" + this.getHost() + ", appKey=" + this.getAppKey() + ", version=" + this.getVersion() + ", format=" + this.getFormat() + ")";
        }
    }
}

