/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.invoice.impl;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.modules.invoice.JanusHtmlToPdfService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JanusHtmlToPdfServiceImpl
implements JanusHtmlToPdfService {
    private static final Logger log = LoggerFactory.getLogger(JanusHtmlToPdfServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult janusHtmlToPdf(String htmlContent, String serialNo) {
        try {
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(serialNo).action(this.janusActionConfig.getJanusHtml2Pdf()).tenantId(this.janusConfig.getTenantCode()).isValid(0).data(htmlContent).build();
            JsonResult jsonResult = this.okHttpClientUtils.postFormDate(janusRequest);
            if (jsonResult.isFail()) {
                log.info("<=== html\u8f6cpdf\u5931\u8d25 \uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            byte[] bytes = (byte[])jsonResult.getData();
            if (null == bytes) {
                return JsonResult.error(jsonResult.getMessage());
            }
            jsonResult.setData(bytes);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5e73\u53f0html\u8f6cpdf\u5f02\u5e38:", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }
}

