/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.util.StringValueResolver;

public final class SpringUtils {
    private static final Logger log = LoggerFactory.getLogger(SpringUtils.class);
    private static volatile SpringUtils instance;
    private ApplicationContext applicationContext;
    private StringValueResolver stringValueResolver;
    private int webServerPort;

    private SpringUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpringUtils getInstance() {
        if (instance != null) return instance;
        Class<SpringUtils> clazz = SpringUtils.class;
        synchronized (SpringUtils.class) {
            if (instance != null) return instance;
            instance = new SpringUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static Optional<ApplicationContext> getContext() {
        return Optional.ofNullable(SpringUtils.getInstance().applicationContext);
    }

    public static <T> Optional<T> getBean(Class<T> requiredType) {
        return SpringUtils.getContext().map(ctx -> ctx.getBean(requiredType));
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> requiredType) {
        return SpringUtils.getContext().map(ctx -> ctx.getBeansOfType(requiredType)).orElseGet(HashMap::new);
    }

    public static String getAppName() {
        return SpringUtils.getProperty("spring.application.name");
    }

    public static int getAppPort() {
        return SpringUtils.getInstance().webServerPort;
    }

    public static String getProperty(String key) {
        return SpringUtils.getProperty(key, "");
    }

    public static String getProperty(String key, String defaultValue) {
        return SpringUtils.getContext().map(EnvironmentCapable::getEnvironment).map(env -> env.getProperty(key, defaultValue)).orElse("");
    }

    public static <T> T getProperty(String key, Class<T> targetType) {
        return SpringUtils.getProperty(key, targetType);
    }

    public static <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)SpringUtils.getContext().map(EnvironmentCapable::getEnvironment).map(env -> env.getProperty(key, targetType, defaultValue)).orElse(defaultValue);
    }

    public static String resolveStringValue(String strVal) {
        return SpringUtils.resolveStringValue(strVal, "");
    }

    public static String resolveStringValue(String strVal, String defaultValue) {
        return Optional.ofNullable(SpringUtils.getInstance().stringValueResolver).map(svr -> svr.resolveStringValue(strVal)).orElse(defaultValue);
    }

    public static void publishEvent(Object event) {
        log.debug("publish payload event - {}", event);
        SpringUtils.getContext().ifPresent(ctx -> ctx.publishEvent(event));
    }

    public static <T> void publishEvent(Supplier<T> eventSupplier) {
        SpringUtils.publishEvent(eventSupplier.get());
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }

    public void setWebServerPort(int webServerPort) {
        this.webServerPort = webServerPort;
    }
}

