/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.alerter;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.evat.common.alerter.Alerter;
import com.xforceplus.evat.common.alerter.AlerterConfig;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Calendar;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"fat", "sit"})
public class DingDingAlerter
implements Alerter {
    private static final Logger log = LoggerFactory.getLogger(DingDingAlerter.class);
    private final AlerterConfig config;
    @Value(value="${spring.application.name}")
    private String appName;
    private static final String TEXT_TEMPLATE = "### <font color=red>%s</font>\n > %s \n > ###### \u6545\u969c\u73af\u5883\uff1a%s\n > ###### \u4e3b\u673a\u540d\u79f0\uff1a%s\n > ###### \u544a\u8b66\u65f6\u95f4\uff1a%s\n > ###### \u544a\u8b66\u5185\u5bb9\uff1a%s\n > ###### \u5806\u6808\u4fe1\u606f\uff1a%s";
    private static final String STACKTRACE_TEMPLATE = "\n```\n%s\n```";
    @Value(value="${spring.profiles.active}")
    private String env;

    @Override
    public void alert(String title) {
        this.alert(title, "", null);
    }

    @Override
    public void alert(String title, String content) {
        this.alert(title, content, null);
    }

    @Override
    public void alert(String title, String content, Exception exception) {
        if (this.config.isEnabled()) {
            String requestBody = this.buildRequestBody(title, content, exception);
            this.send(requestBody);
        }
    }

    @Override
    public void alert(Exception exception) {
        this.alert("", "", exception);
    }

    @Override
    public void alert(String title, Exception exception) {
        this.alert(title, "", exception);
    }

    private String buildRequestBody(String title, String content, Exception exception) {
        String hostname = this.obtainHostname();
        String stacktrace = this.obtainStacktrace(exception);
        if (StringUtils.isNotEmpty((CharSequence)stacktrace)) {
            stacktrace = String.format(STACKTRACE_TEMPLATE, stacktrace);
        }
        String text = String.format(TEXT_TEMPLATE, this.appName, title, this.env, hostname, Calendar.getInstance().getTime(), content, stacktrace);
        JSONObject markdown = new JSONObject();
        markdown.put("title", (Object)title);
        markdown.put("text", (Object)text);
        JSONObject body = new JSONObject();
        body.put("msgtype", (Object)"markdown");
        body.put("markdown", (Object)markdown);
        log.info(body.toJSONString());
        return body.toJSONString();
    }

    private void send(String requestBody) {
        log.info("\u5f00\u59cb\u53d1\u9001\u9489\u9489\u544a\u8b66\u63d0\u793a");
        String url = null;
        try {
            url = this.config.getWebhookApi() + this.encode(this.config.getSecret());
        }
        catch (Exception e) {
            log.error("\u9489\u9489\u544a\u8b66\u53d1\u9001\u5f02\u5e38", (Throwable)e);
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/json;charset=utf8");
        StringEntity entity = new StringEntity(requestBody, "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            log.debug("alert response status = " + response.getStatusLine());
            HttpEntity responseEntity = response.getEntity();
            if (Objects.nonNull(responseEntity)) {
                log.debug("alert response length = {}, alert response = {}", (Object)responseEntity.getContentLength(), (Object)EntityUtils.toString((HttpEntity)responseEntity));
            }
        }
        catch (Exception e) {
            log.error("\u9489\u9489\u544a\u8b66\u53d1\u9001\u5f02\u5e38", (Throwable)e);
        }
    }

    private String encode(String secret) throws Exception {
        Long timestamp = System.currentTimeMillis();
        String stringToSign = timestamp + "\n" + secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256"));
        byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
        Base64.Encoder encoder = Base64.getEncoder();
        String sign = URLEncoder.encode(new String(encoder.encodeToString(signData)), "UTF-8");
        return "&timestamp=" + timestamp + "&sign=" + sign;
    }

    public DingDingAlerter(AlerterConfig config) {
        this.config = config;
    }
}

