/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.domain.invoiceEntryAccount;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EntryAccountResult<T>
implements Serializable {
    public static final String OK = "XFWAPP0000";
    public static final String FAIL = "XFWAPP0001";
    public static final String INTERMEDIATE_STATE = "XFWAPP0002";
    private String code;
    private String message;
    private T result;

    public EntryAccountResult() {
    }

    public EntryAccountResult(T result, String message, String code) {
        this.result = result;
        this.message = message;
        this.code = code;
    }

    public static <T> EntryAccountResult<T> ok(T result) {
        EntryAccountResult<T> r = new EntryAccountResult<T>();
        r.code = OK;
        r.result = result;
        return r;
    }

    public static <T> EntryAccountResult<T> ok() {
        return EntryAccountResult.ok(null);
    }

    public static <T> EntryAccountResult<T> ok(T result, String message) {
        EntryAccountResult<T> r = EntryAccountResult.ok(result);
        r.message = message;
        return r;
    }

    public static <T> EntryAccountResult<T> fail(String message) {
        EntryAccountResult<T> r = new EntryAccountResult<T>();
        r.code = FAIL;
        r.message = message;
        return r;
    }

    public static <T> EntryAccountResult<T> fail(String message, String code) {
        EntryAccountResult<T> r = new EntryAccountResult<T>();
        r.message = message;
        r.code = StringUtils.isBlank((CharSequence)code) ? FAIL : code;
        return r;
    }

    @JsonIgnore
    public boolean isOK() {
        return Objects.equals(1, this.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntryAccountResult)) {
            return false;
        }
        EntryAccountResult other = (EntryAccountResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntryAccountResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "EntryAccountResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", result=" + this.getResult() + ")";
    }

    public static class InvoiceEntryResult
    implements Serializable {
        private String invoiceNo;
        private String invoiceCode;
        private String entryTime;
        private String entryStatus;

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public String getInvoiceCode() {
            return this.invoiceCode;
        }

        public String getEntryTime() {
            return this.entryTime;
        }

        public String getEntryStatus() {
            return this.entryStatus;
        }

        public void setInvoiceNo(String invoiceNo) {
            this.invoiceNo = invoiceNo;
        }

        public void setInvoiceCode(String invoiceCode) {
            this.invoiceCode = invoiceCode;
        }

        public void setEntryTime(String entryTime) {
            this.entryTime = entryTime;
        }

        public void setEntryStatus(String entryStatus) {
            this.entryStatus = entryStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceEntryResult)) {
                return false;
            }
            InvoiceEntryResult other = (InvoiceEntryResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$invoiceNo = this.getInvoiceNo();
            String other$invoiceNo = other.getInvoiceNo();
            if (this$invoiceNo == null ? other$invoiceNo != null : !this$invoiceNo.equals(other$invoiceNo)) {
                return false;
            }
            String this$invoiceCode = this.getInvoiceCode();
            String other$invoiceCode = other.getInvoiceCode();
            if (this$invoiceCode == null ? other$invoiceCode != null : !this$invoiceCode.equals(other$invoiceCode)) {
                return false;
            }
            String this$entryTime = this.getEntryTime();
            String other$entryTime = other.getEntryTime();
            if (this$entryTime == null ? other$entryTime != null : !this$entryTime.equals(other$entryTime)) {
                return false;
            }
            String this$entryStatus = this.getEntryStatus();
            String other$entryStatus = other.getEntryStatus();
            return !(this$entryStatus == null ? other$entryStatus != null : !this$entryStatus.equals(other$entryStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvoiceEntryResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $invoiceNo = this.getInvoiceNo();
            result = result * 59 + ($invoiceNo == null ? 43 : $invoiceNo.hashCode());
            String $invoiceCode = this.getInvoiceCode();
            result = result * 59 + ($invoiceCode == null ? 43 : $invoiceCode.hashCode());
            String $entryTime = this.getEntryTime();
            result = result * 59 + ($entryTime == null ? 43 : $entryTime.hashCode());
            String $entryStatus = this.getEntryStatus();
            result = result * 59 + ($entryStatus == null ? 43 : $entryStatus.hashCode());
            return result;
        }

        public String toString() {
            return "EntryAccountResult.InvoiceEntryResult(invoiceNo=" + this.getInvoiceNo() + ", invoiceCode=" + this.getInvoiceCode() + ", entryTime=" + this.getEntryTime() + ", entryStatus=" + this.getEntryStatus() + ")";
        }
    }

    public static class Result
    implements Serializable {
        private Boolean taskFlag;
        private InvoiceEntryResult InvoiceEntryResult;

        public Boolean getTaskFlag() {
            return this.taskFlag;
        }

        public InvoiceEntryResult getInvoiceEntryResult() {
            return this.InvoiceEntryResult;
        }

        public void setTaskFlag(Boolean taskFlag) {
            this.taskFlag = taskFlag;
        }

        public void setInvoiceEntryResult(InvoiceEntryResult InvoiceEntryResult2) {
            this.InvoiceEntryResult = InvoiceEntryResult2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$taskFlag = this.getTaskFlag();
            Boolean other$taskFlag = other.getTaskFlag();
            if (this$taskFlag == null ? other$taskFlag != null : !((Object)this$taskFlag).equals(other$taskFlag)) {
                return false;
            }
            InvoiceEntryResult this$InvoiceEntryResult = this.getInvoiceEntryResult();
            InvoiceEntryResult other$InvoiceEntryResult = other.getInvoiceEntryResult();
            return !(this$InvoiceEntryResult == null ? other$InvoiceEntryResult != null : !((Object)this$InvoiceEntryResult).equals(other$InvoiceEntryResult));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $taskFlag = this.getTaskFlag();
            result = result * 59 + ($taskFlag == null ? 43 : ((Object)$taskFlag).hashCode());
            InvoiceEntryResult $InvoiceEntryResult = this.getInvoiceEntryResult();
            result = result * 59 + ($InvoiceEntryResult == null ? 43 : ((Object)$InvoiceEntryResult).hashCode());
            return result;
        }

        public String toString() {
            return "EntryAccountResult.Result(taskFlag=" + this.getTaskFlag() + ", InvoiceEntryResult=" + this.getInvoiceEntryResult() + ")";
        }
    }
}

