/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.xforceplus.evat.common.utils.SpringUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static volatile JsonUtils instance;
    private final ObjectMapper OBJECT_MAPPER = Jackson2ObjectMapperBuilder.json().simpleDateFormat("yyyy-MM-dd HH:mm:ss").featuresToDisable(new Object[]{SerializationFeature.FAIL_ON_EMPTY_BEANS, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).serializationInclusion(JsonInclude.Include.NON_NULL).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY).build();

    private JsonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return SpringUtils.getBean(ObjectMapper.class).orElse(JsonUtils.getInstance().OBJECT_MAPPER);
    }

    public static TypeFactory getTypeFactory() {
        return JsonUtils.getObjectMapper().getTypeFactory();
    }

    public static <T> T fromJson(String json, Class<T> valueType) {
        Object t = null;
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                t = JsonUtils.getObjectMapper().readValue(json, valueType);
            }
            catch (IOException jpe) {
                log.warn("Json processing failure\uff1a{}", (Object)json, (Object)jpe);
            }
        }
        return (T)t;
    }

    public static <T> List<T> fromJson2List(String json, Class<T> clazz) {
        List t = Collections.emptyList();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                t = (List)JsonUtils.getObjectMapper().readValue(json, (JavaType)JsonUtils.getTypeFactory().constructCollectionType(List.class, clazz));
            }
            catch (IOException e) {
                log.error("JSON\u8f6c\u5316\u4e3a\u96c6\u5408\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return t;
    }

    public static <T> T toBean(Object value, Class<T> valueType) {
        if (TypeUtils.isInstance((Object)value, valueType)) {
            return (T)value;
        }
        return JsonUtils.toBean(JsonUtils.toJson(value), valueType).orElse(null);
    }

    public static <T> T toBean(Object value, Type valueType) {
        if (TypeUtils.isInstance((Object)value, (Type)valueType)) {
            return (T)value;
        }
        Optional<Object> bean = JsonUtils.toBean(JsonUtils.toJson(value), valueType);
        return bean.orElse(null);
    }

    public static <T> Optional<T> toBean(String json, Class<T> clazz) {
        try {
            return Optional.ofNullable(JsonUtils.getObjectMapper().readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            log.warn("json2bean4class.ex:{}", (Object)json, (Object)e);
            return Optional.empty();
        }
    }

    public static <T> Optional<T> toBean(String json, Type valueType) {
        try {
            return Optional.ofNullable(JsonUtils.getObjectMapper().readValue(json, JsonUtils.getTypeFactory().constructType(valueType)));
        }
        catch (JsonProcessingException e) {
            log.warn("json2bean4type.ex:{}", (Object)json, (Object)e);
            return Optional.empty();
        }
    }

    public static String toJson(Object object) {
        if (object instanceof String || object == null) {
            return (String)object;
        }
        try {
            return JsonUtils.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.warn("", (Throwable)e);
            return null;
        }
    }

    public static String toJson(Object object, String filterName, String ... propertyArray) {
        SimpleBeanPropertyFilter propertyFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])propertyArray);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(filterName, propertyFilter);
        return JsonUtils.toJson(object, (FilterProvider)filterProvider);
    }

    public static String toJson(Object object, FilterProvider filterProvider) {
        if (object instanceof String || object == null) {
            return (String)object;
        }
        try {
            return JsonUtils.getObjectMapper().writer(filterProvider).writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.warn("", (Throwable)e);
            return null;
        }
    }

    public static boolean isJson(String content) {
        boolean bool = true;
        try {
            JsonUtils.getObjectMapper().readTree(content);
        }
        catch (Exception var3) {
            bool = false;
        }
        return bool;
    }

    public static Object[] wrapJsonByType(String jsonArgs, Type ... parameterTypes) {
        Object[] nArgs = new Object[parameterTypes.length];
        if (parameterTypes.length == 0) {
            return nArgs;
        }
        if (jsonArgs.startsWith("[")) {
            List argsJson = JsonUtils.fromJson(jsonArgs, List.class);
            for (int i = 0; i < argsJson.size() && i < parameterTypes.length; ++i) {
                nArgs[i] = JsonUtils.toBean(argsJson.get(i), parameterTypes[i]);
            }
        } else {
            nArgs[0] = JsonUtils.toBean(jsonArgs, parameterTypes[0]);
        }
        return nArgs;
    }

    public static Object[] wrapJsonByClass(String jsonArgs, Class<?> ... parameterTypes) {
        return JsonUtils.wrapJsonByType(jsonArgs, parameterTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonUtils getInstance() {
        if (null != instance) return instance;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (null != instance) return instance;
            instance = new JsonUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

