/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.utils.TraceUtils;
import io.vavr.control.Either;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OkHttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClientUtils.class);
    @Autowired
    private JanusConfig janusConfig;
    private OkHttpClient okHttpClient;

    @PostConstruct
    private void initOkHttpClient() {
        this.okHttpClient = OkHttpClientUtils.buildUnsafeOKHttpClient().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(10, 6L, TimeUnit.MINUTES)).protocols(Collections.singletonList(Protocol.HTTP_1_1)).build();
    }

    public JsonResult sendMsg(JanusRequest janusRequest) {
        JsonResult<String> jsonResult = JsonResult.error("\u53d1\u9001\u5e73\u53f0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        try {
            JanusRequest newJanusRequest = new JanusRequest();
            BeanUtils.copyProperties((Object)janusRequest, (Object)newJanusRequest);
            if (StringUtils.isBlank((CharSequence)newJanusRequest.getPayLoadId())) {
                String trace_id = TraceUtils.getMdcTraceId();
                String payLoadId = (String)StringUtils.defaultIfBlank((CharSequence)trace_id, (CharSequence)(this.janusConfig.getGroupFlag() + System.currentTimeMillis()));
                newJanusRequest.setPayLoadId(payLoadId);
            }
            Headers.Builder headerBuilder = new Headers.Builder();
            headerBuilder.add("Accept-Encoding", "deflate");
            headerBuilder.add("serialNo", newJanusRequest.getPayLoadId());
            headerBuilder.add("timestamp", new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
            headerBuilder.add("action", newJanusRequest.getAction());
            headerBuilder.add("Authentication", this.janusConfig.getHttp().getAuthentication());
            headerBuilder.add("rpcType", "http");
            headerBuilder.add("tenant-id", (String)StringUtils.defaultIfBlank((CharSequence)newJanusRequest.getTenantId(), (CharSequence)this.janusConfig.getTenantId()));
            headerBuilder.add("customerNo", this.janusConfig.getTcp().getCustomerNo());
            headerBuilder.add("uiaSign", this.janusConfig.getHttp().getUiaSign());
            if (newJanusRequest.getHeader() != null) {
                for (String key : newJanusRequest.getHeader().keySet()) {
                    String val = newJanusRequest.getHeader().get(key);
                    if (StringUtils.isBlank((CharSequence)val)) continue;
                    headerBuilder.add(key, val);
                }
            }
            String body = "";
            body = "JSON".equals(newJanusRequest.getDataType()) ? newJanusRequest.getData() + "" : JacksonUtil.getInstance().toJson(newJanusRequest.getData(), "file-base64");
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)body);
            int contentLengthKb = new BigDecimal(requestBody.contentLength()).divide(new BigDecimal(1024)).setScale(2, 4).intValue();
            if (contentLengthKb > this.janusConfig.getHttp().getGzipEnableThreshold()) {
                headerBuilder.add("Content-Encoding", "gzip");
            }
            Request.Builder requestBuilder = new Request.Builder().url(this.janusConfig.getHttp().getBaseHost()).headers(headerBuilder.build());
            if ("PUT".equalsIgnoreCase(newJanusRequest.getRequestMethod())) {
                requestBuilder.put(requestBody);
            } else {
                requestBuilder.post(requestBody);
            }
            log.info("===> \u53d1\u9001\u5e73\u53f0, \u8bf7\u6c42\u6d41\u6c34\u53f7[{}], \u8bf7\u6c42\u62a5\u6587={}", (Object)newJanusRequest.getPayLoadId(), (Object)body);
            Response response = this.okHttpClient.newCall(requestBuilder.build()).execute();
            String result = response.body().string();
            log.info("<=== \u53d1\u9001\u5e73\u53f0, \u8bf7\u6c42\u6d41\u6c34\u53f7[{}], \u5e73\u53f0\u53cd\u9988={}", (Object)newJanusRequest.getPayLoadId(), (Object)result);
            if (response.isSuccessful()) {
                jsonResult = JsonResult.ok("\u53d1\u9001\u5e73\u53f0\u6210\u529f");
            }
            jsonResult.setData(result);
        }
        catch (Exception e) {
            log.error("error={}", (Throwable)e);
            jsonResult.setMessage(e.getMessage());
        }
        return jsonResult;
    }

    public JsonResult sendGetMsg(JanusRequest janusRequest) {
        JsonResult<String> jsonResult = JsonResult.error("\u53d1\u9001\u5e73\u53f0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        try {
            JanusRequest newJanusRequest = new JanusRequest();
            BeanUtils.copyProperties((Object)janusRequest, (Object)newJanusRequest);
            if (StringUtils.isBlank((CharSequence)newJanusRequest.getPayLoadId())) {
                String trace_id = TraceUtils.getMdcTraceId();
                String payLoadId = (String)StringUtils.defaultIfBlank((CharSequence)trace_id, (CharSequence)(this.janusConfig.getGroupFlag() + System.currentTimeMillis()));
                newJanusRequest.setPayLoadId(payLoadId);
            }
            Headers.Builder headerBuilder = new Headers.Builder();
            headerBuilder.add("Accept-Encoding", "deflate");
            headerBuilder.add("serialNo", newJanusRequest.getPayLoadId());
            headerBuilder.add("timestamp", new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
            headerBuilder.add("action", newJanusRequest.getAction());
            headerBuilder.add("Authentication", this.janusConfig.getHttp().getAuthentication());
            headerBuilder.add("rpcType", "http");
            headerBuilder.add("tenant-id", (String)StringUtils.defaultIfBlank((CharSequence)newJanusRequest.getTenantId(), (CharSequence)this.janusConfig.getTenantId()));
            headerBuilder.add("customerNo", this.janusConfig.getTcp().getCustomerNo());
            headerBuilder.add("uiaSign", this.janusConfig.getHttp().getUiaSign());
            if (newJanusRequest.getHeader() != null) {
                for (String string : newJanusRequest.getHeader().keySet()) {
                    String string2 = newJanusRequest.getHeader().get(string);
                    if (StringUtils.isBlank((CharSequence)string2)) continue;
                    headerBuilder.add(string, string2);
                }
            }
            HttpUrl.Builder httpUrlBuilder = HttpUrl.parse((String)this.janusConfig.getHttp().getBaseHost()).newBuilder();
            if (newJanusRequest.getParams() != null && newJanusRequest.getParams().size() > 0) {
                for (Map.Entry<String, String> entry : newJanusRequest.getParams().entrySet()) {
                    if (entry.getKey().equalsIgnoreCase("class")) continue;
                    httpUrlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
                }
            }
            Request request = new Request.Builder().url(httpUrlBuilder.build()).headers(headerBuilder.build()).get().build();
            log.info("===> \u53d1\u9001\u5e73\u53f0, \u6d41\u6c34\u53f7[{}],Header={},Url ={},", new Object[]{newJanusRequest.getPayLoadId(), JacksonUtil.getInstance().toJson(newJanusRequest.getHeader()), request.url()});
            Response response = this.okHttpClient.newCall(request).execute();
            String result = null;
            if (response.body() != null) {
                result = response.body().string();
            }
            if (response.isSuccessful()) {
                jsonResult = JsonResult.ok();
                jsonResult.setMessage("\u8bf7\u6c42\u6210\u529f");
            }
            jsonResult.setData(result);
            log.info("<=== \u53d1\u9001\u5e73\u53f0, \u6d41\u6c34\u53f7[{}], \u5e73\u53f0\u53cd\u9988={}", (Object)newJanusRequest.getPayLoadId(), (Object)result);
        }
        catch (Exception e) {
            jsonResult.setMessage(e.getMessage());
            log.error("error={}", (Throwable)e);
        }
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonResult postFormDate(JanusRequest janusRequest) {
        JsonResult<byte[]> jsonResult = JsonResult.error("\u53d1\u9001\u5e73\u53f0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        File htmlFile = null;
        try {
            JanusRequest newJanusRequest = new JanusRequest();
            BeanUtils.copyProperties((Object)janusRequest, (Object)newJanusRequest);
            if (StringUtils.isBlank((CharSequence)newJanusRequest.getPayLoadId())) {
                String trace_id = TraceUtils.getMdcTraceId();
                String payLoadId = (String)StringUtils.defaultIfBlank((CharSequence)trace_id, (CharSequence)(this.janusConfig.getGroupFlag() + System.currentTimeMillis()));
                newJanusRequest.setPayLoadId(payLoadId);
            }
            Headers.Builder headerBuilder = new Headers.Builder();
            headerBuilder.add("Accept-Encoding", "deflate");
            headerBuilder.add("serialNo", newJanusRequest.getPayLoadId());
            headerBuilder.add("timestamp", new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
            headerBuilder.add("action", newJanusRequest.getAction());
            headerBuilder.add("Authentication", this.janusConfig.getHttp().getAuthentication());
            headerBuilder.add("rpcType", "http");
            headerBuilder.add("tenant-id", (String)StringUtils.defaultIfBlank((CharSequence)newJanusRequest.getTenantId(), (CharSequence)this.janusConfig.getTenantId()));
            headerBuilder.add("customerNo", this.janusConfig.getTcp().getCustomerNo());
            headerBuilder.add("uiaSign", this.janusConfig.getHttp().getUiaSign());
            headerBuilder.add("tenantCode", this.janusConfig.getTenantCode());
            if (newJanusRequest.getHeader() != null) {
                for (String key : newJanusRequest.getHeader().keySet()) {
                    String val = newJanusRequest.getHeader().get(key);
                    if (StringUtils.isBlank((CharSequence)val)) continue;
                    headerBuilder.add(key, val);
                }
            }
            htmlFile = new File(janusRequest.getPayLoadId() + ".html");
            FileWriter writer = new FileWriter(htmlFile);
            writer.write((String)janusRequest.getData());
            writer.close();
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("htmlFile", "1698654155086.xml.html", RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)htmlFile)).build();
            Request.Builder requestBuilder = new Request.Builder().url(this.janusConfig.getHttp().getBaseHost() + "").headers(headerBuilder.build());
            requestBuilder.post((RequestBody)requestBody);
            log.info("===> \u53d1\u9001\u5e73\u53f0, \u8bf7\u6c42\u6d41\u6c34\u53f7[{}], \u8bf7\u6c42\u62a5\u6587={}", (Object)newJanusRequest.getPayLoadId(), (Object)requestBody);
            Response response = this.okHttpClient.newCall(requestBuilder.build()).execute();
            String string = response.body().toString();
            byte[] result = response.body().bytes();
            log.info("<=== \u53d1\u9001\u5e73\u53f0, \u8bf7\u6c42\u6d41\u6c34\u53f7[{}], \u5e73\u53f0\u53cd\u9988={}", (Object)newJanusRequest.getPayLoadId(), (Object)result);
            if (response.isSuccessful()) {
                jsonResult.setCode("0");
                jsonResult.setMessage("\u6210\u529f");
                jsonResult.setData(result);
                JsonResult<byte[]> jsonResult2 = jsonResult;
                return jsonResult2;
            }
        }
        catch (Exception e) {
            log.error("error={}", (Throwable)e);
            jsonResult.setMessage(e.getMessage());
        }
        finally {
            if (null != htmlFile) {
                htmlFile.delete();
            }
        }
        return jsonResult;
    }

    public Either<String, String> post(String url, String body) {
        return this.post(url, body, null, null);
    }

    public Either<String, String> post(String url, String body, Map<String, String> headerMap, MediaType mediaType) {
        try {
            if (mediaType == null) {
                mediaType = MediaType.parse((String)"application/json");
            }
            if (headerMap == null) {
                headerMap = new HashMap<String, String>();
            }
            RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)body);
            Headers.Builder headerBuilder = new Headers.Builder();
            for (Map.Entry<String, String> headerItem : headerMap.entrySet()) {
                headerBuilder.add(headerItem.getKey(), headerItem.getValue());
            }
            Request.Builder requestBuilder = new Request.Builder().url(url).headers(headerBuilder.build()).post(requestBody);
            log.info("===> \u53d1\u9001\u8bf7\u6c42, URL={}, \u8bf7\u6c42\u62a5\u6587={}", (Object)url, (Object)body);
            Response response = this.okHttpClient.newCall(requestBuilder.build()).execute();
            String result = response.body().string();
            log.info("<=== \u53d1\u9001\u8bf7\u6c42, \u8fd4\u56de\u62a5\u6587={}", (Object)result);
            if (response.isSuccessful()) {
                return Either.right((Object)result);
            }
            return Either.left((Object)result);
        }
        catch (SocketTimeoutException e) {
            log.error("error=", (Throwable)e);
            return Either.left((Object)"\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
            return Either.left((Object)e.getMessage());
        }
    }

    public static OkHttpClient.Builder buildUnsafeOKHttpClient() {
        try {
            TrustManager[] trustAllCerts = OkHttpClientUtils.buildTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier((hostname, session) -> true);
            return builder;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("error=", (Throwable)e);
            return new OkHttpClient.Builder();
        }
    }

    private static TrustManager[] buildTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

