/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public enum FileTypeEnum {
    PICTURE("1", "\u53d1\u7968\u56fe\u7247", null),
    ATTACHMENT("2", "\u9644\u4ef6", null),
    ELECTRONIC_INVOICE_PDF("3", "\u7535\u5b50\u53d1\u7968\u6e90\u6587\u4ef6", "pdf"),
    ELECTRONIC_INVOICE_OFD("3", "\u7535\u5b50\u53d1\u7968\u6e90\u6587\u4ef6", "ofd"),
    ELECTRONIC_INVOICE_XML("3", "\u7535\u5b50\u53d1\u7968\u6e90\u6587\u4ef6", "xml");

    private String fileType;
    private String msgTip;
    private String suffix;

    private FileTypeEnum(String fileType, String msgTip, String suffix) {
        this.fileType = fileType;
        this.msgTip = msgTip;
        this.suffix = suffix;
    }

    public static Boolean isElectronicInvoice(String fileType, String suffix) {
        List fileTypeCollect = FileTypeEnum.electronicInvoices().stream().filter(fileTypeEnum -> StringUtils.equals((CharSequence)fileTypeEnum.fileType, (CharSequence)fileType)).collect(Collectors.toList());
        List suffixCollect = FileTypeEnum.electronicInvoices().stream().filter(fileTypeEnum -> StringUtils.equals((CharSequence)fileTypeEnum.suffix, (CharSequence)suffix.toLowerCase())).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(fileTypeCollect) && !CollectionUtils.isEmpty(suffixCollect);
    }

    private static EnumSet<FileTypeEnum> electronicInvoices() {
        return EnumSet.of(ELECTRONIC_INVOICE_PDF, ELECTRONIC_INVOICE_OFD, ELECTRONIC_INVOICE_XML);
    }
}

