/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.taxware.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.customs.CustomsTaxCheckRequest;
import com.xforceplus.evat.common.domain.customs.CustomsTaxCheckResponse;
import com.xforceplus.evat.common.modules.taxware.CustomsTaxService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomsTaxServiceImpl
implements CustomsTaxService {
    private static final Logger log = LoggerFactory.getLogger(CustomsTaxServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult check(CustomsTaxCheckRequest customsTaxCheckRequest) {
        log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u8bf7\u6c42\u53c2\u6570:{}", JSON.toJSON((Object)customsTaxCheckRequest));
        try {
            Tuple2<Boolean, String> checkRequest = this.checkRequest(customsTaxCheckRequest);
            if (((Boolean)checkRequest._1()).booleanValue()) {
                return JsonResult.error((String)checkRequest._2());
            }
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(customsTaxCheckRequest.getCustomsPaymentNo()).action(this.janusActionConfig.getTaxwareCheckAction()).tenantId(this.janusConfig.getTenantCode()).header(heaserMap).isValid(0).data(customsTaxCheckRequest).build();
            JsonResult<CustomsTaxCheckResponse.TaxWareCheckResponseResult> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u8bf7\u6c42\uff0c\u8fd4\u56de\u62a5\u6587 = {}", JSON.toJSON((Object)jsonResult));
            String data = String.valueOf(jsonResult.getData());
            CustomsTaxCheckResponse customsTaxCheckResponse = (CustomsTaxCheckResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<CustomsTaxCheckResponse>(){}, (Feature[])new Feature[0]);
            if (!customsTaxCheckResponse.isOk()) {
                return JsonResult.error(customsTaxCheckResponse.getCode() + "", customsTaxCheckResponse.getMessage());
            }
            jsonResult = JsonResult.ok(customsTaxCheckResponse.getMessage());
            jsonResult.setData(customsTaxCheckResponse.getResult());
            log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u52fe\u9009\u8bf7\u6c42\u6700\u7ec8\u8fd4\u56de\u62a5\u6587:{}", JSON.toJSON(jsonResult));
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult checkResult(String taskId) {
        log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570:{}", (Object)taskId);
        try {
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return JsonResult.error("taskId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("taskId", taskId);
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(taskId).action(this.janusActionConfig.getTaxwareCheckResultAction()).tenantId(this.janusConfig.getTenantCode()).header(heaserMap).isValid(0).data(taskId).build();
            JsonResult jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
            log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u7ed3\u679c\u8bf7\u6c42\uff0c\u8fd4\u56de\u62a5\u6587 = {}", JSON.toJSON((Object)jsonResult));
            String data = String.valueOf(jsonResult.getData());
            log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u52fe\u9009\u7ed3\u679c\u83b7\u53d6\u6700\u7ec8\u8fd4\u56de\u62a5\u6587:{}", (Object)data);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u7ed3\u679c\u8bf7\u6c42\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    public Tuple2<Boolean, String> checkRequest(CustomsTaxCheckRequest customsTaxCheckRequest) {
        if (Objects.isNull(customsTaxCheckRequest)) {
            return Tuple.of((Object)true, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)customsTaxCheckRequest.getCustomsPaymentNo())) {
            return Tuple.of((Object)true, (Object)"\u8bf7\u6d77\u5173\u7f34\u6b3e\u4e66\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)customsTaxCheckRequest.getTaxNo())) {
            return Tuple.of((Object)true, (Object)"\u6709\u6548\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)customsTaxCheckRequest.getDateIssued())) {
            return Tuple.of((Object)true, (Object)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)customsTaxCheckRequest.getTaxPeriod())) {
            return Tuple.of((Object)true, (Object)"\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)customsTaxCheckRequest.getAuthUse())) {
            return Tuple.of((Object)true, (Object)"\u8ba4\u8bc1\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Tuple.of((Object)false, (Object)"");
    }
}

