/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.ncp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.alerter.Alerter;
import com.xforceplus.evat.common.configuration.ProfileConfig;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.enums.ncp.NcpAuthUseEnum;
import com.xforceplus.evat.common.constant.enums.ncp.NcpHandleTypeEnum;
import com.xforceplus.evat.common.constant.enums.ncp.NcpIsCheckEnum;
import com.xforceplus.evat.common.constant.enums.ncp.NcpTypeEnum;
import com.xforceplus.evat.common.domain.JanusOpenApiAsynResult;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.ncp.NcpJjkcInvoiceResquestDto;
import com.xforceplus.evat.common.domain.ncp.NcpJjkcInvoiceTaskResult;
import com.xforceplus.evat.common.domain.ncp.NcpUseInvoiceRequestDto;
import com.xforceplus.evat.common.domain.ncp.NcpUseInvoiceTaskResult;
import com.xforceplus.evat.common.modules.ncp.NcpInvoiceService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NcpInvoiceServiceImpl
implements NcpInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(NcpInvoiceServiceImpl.class);
    @Autowired
    private ProfileConfig profileConfig;
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;
    @Autowired
    private Alerter alerter;

    @Override
    public JsonResult ncpUseInvoiceQuery(NcpUseInvoiceRequestDto ncpUseInvoiceResquest) {
        ncpUseInvoiceResquest.setBb("4");
        if (!this.profileConfig.isProfileActive("prod") && StringUtils.isEmpty((CharSequence)ncpUseInvoiceResquest.getDebug())) {
            ncpUseInvoiceResquest.setDebug("1");
        }
        log.info(">>>>>> \u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)ncpUseInvoiceResquest));
        try {
            Tuple2<Boolean, String> checkRequest = this.checkUseInvoiceRequest(ncpUseInvoiceResquest);
            if (((Boolean)checkRequest._1()).booleanValue()) {
                return JsonResult.error((String)checkRequest._2());
            }
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            JanusRequest janusRequest = JanusRequest.builder().build();
            String payLoadId = ncpUseInvoiceResquest.getInvoiceNo();
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            janusRequest.setPayLoadId(payLoadId);
            janusRequest.setAction(this.janusActionConfig.getNcpUseInvoiceQuery());
            janusRequest.setData(JSONObject.toJSONString((Object)ncpUseInvoiceResquest));
            janusRequest.setHeader(heaserMap);
            janusRequest.setDataType("JSON");
            JsonResult<String> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< \u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7 result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            JanusOpenApiAsynResult janusOpenApiAsynResult = (JanusOpenApiAsynResult)JSON.parseObject((String)data, JanusOpenApiAsynResult.class);
            if (!janusOpenApiAsynResult.isOK()) {
                if (null != janusOpenApiAsynResult.getResult() && null != janusOpenApiAsynResult.getResult().getFailResult()) {
                    return JsonResult.error(janusOpenApiAsynResult.getCode(), JSONObject.toJSONString(janusOpenApiAsynResult.getResult().getFailResult()));
                }
                return JsonResult.error(janusOpenApiAsynResult.getCode(), janusOpenApiAsynResult.getMessage());
            }
            jsonResult = JsonResult.ok(janusOpenApiAsynResult.getMessage());
            jsonResult.setData(janusOpenApiAsynResult.getResult().getTaskId());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7 request error ", (Throwable)e);
            this.alerter.alert("\u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u5931\u8d25", e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult ncpUseInvoiceTaskResult(String taskId) {
        log.info(">>>>>> \u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u83b7\u53d6\u7ed3\u679c\u5165\u53c2:{}", (Object)taskId);
        try {
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return JsonResult.error("taskId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("taskId", taskId);
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(taskId).action(this.janusActionConfig.getNcpUseInvoiceResult()).tenantId(this.janusConfig.getTenantCode()).header(heaserMap).isValid(0).data(taskId).build();
            JsonResult<NcpUseInvoiceTaskResult.NcpUseTaskResult> jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
            log.debug("<<<<<< \u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u83b7\u53d6\u7ed3\u679c result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u83b7\u53d6\u7ed3\u679c\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            NcpUseInvoiceTaskResult ncpUseInvoiceTaskResult = (NcpUseInvoiceTaskResult)JSON.parseObject((String)data, NcpUseInvoiceTaskResult.class);
            if (ncpUseInvoiceTaskResult.isOK() && null != ncpUseInvoiceTaskResult.getResult()) {
                jsonResult = JsonResult.ok(ncpUseInvoiceTaskResult.getMessage());
                jsonResult.setData(ncpUseInvoiceTaskResult.getResult());
                return jsonResult;
            }
            return JsonResult.error(ncpUseInvoiceTaskResult.getCode(), ncpUseInvoiceTaskResult.getMessage());
        }
        catch (Exception e) {
            log.error("\u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u83b7\u53d6\u7ed3\u679c request error ", (Throwable)e);
            this.alerter.alert("\u519c\u4ea7\u54c1\u7528\u9014\u786e\u8ba4\u7533\u8bf7\u83b7\u53d6\u7ed3\u679c\u5931\u8d25", e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult ncpJjkcInvoiceQuery(NcpJjkcInvoiceResquestDto ncpJjkcInvoiceResquestDto) {
        ncpJjkcInvoiceResquestDto.setBb("4");
        if (!this.profileConfig.isProfileActive("prod") && StringUtils.isEmpty((CharSequence)ncpJjkcInvoiceResquestDto.getDebug())) {
            ncpJjkcInvoiceResquestDto.setDebug("1");
        }
        log.info(">>>>>> \u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u5982\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)ncpJjkcInvoiceResquestDto));
        try {
            Tuple2<Boolean, String> checkRequest = this.checkJjkcInvoiceRequest(ncpJjkcInvoiceResquestDto);
            if (((Boolean)checkRequest._1()).booleanValue()) {
                return JsonResult.error((String)checkRequest._2());
            }
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            JanusRequest janusRequest = JanusRequest.builder().build();
            String payLoadId = ncpJjkcInvoiceResquestDto.getInvoiceNo();
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            janusRequest.setPayLoadId(payLoadId);
            janusRequest.setAction(this.janusActionConfig.getNcpKcInvoiceQuery());
            janusRequest.setData(JSONObject.toJSONString((Object)ncpJjkcInvoiceResquestDto));
            janusRequest.setHeader(heaserMap);
            janusRequest.setDataType("JSON");
            JsonResult<String> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< \u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009 result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            JanusOpenApiAsynResult janusOpenApiAsynResult = (JanusOpenApiAsynResult)JSON.parseObject((String)data, JanusOpenApiAsynResult.class);
            if (!janusOpenApiAsynResult.isOK()) {
                if (null != janusOpenApiAsynResult.getResult() && null != janusOpenApiAsynResult.getResult().getFailResult()) {
                    return JsonResult.error(janusOpenApiAsynResult.getCode(), JSONObject.toJSONString(janusOpenApiAsynResult.getResult().getFailResult()));
                }
                return JsonResult.error(janusOpenApiAsynResult.getCode(), janusOpenApiAsynResult.getMessage());
            }
            jsonResult = JsonResult.ok(janusOpenApiAsynResult.getMessage());
            jsonResult.setData(janusOpenApiAsynResult.getResult().getTaskId());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009 request error ", (Throwable)e);
            this.alerter.alert("\u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u5931\u8d25", e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult ncpJjkcInvoiceTaskResult(String taskId) {
        log.info(">>>>>> \u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u83b7\u53d6\u7ed3\u679c\u5165\u53c2:{}", (Object)taskId);
        try {
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return JsonResult.error("taskId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("taskId", taskId);
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(taskId).action(this.janusActionConfig.getNcpKcInvoiceResult()).tenantId(this.janusConfig.getTenantCode()).header(heaserMap).isValid(0).data(taskId).build();
            JsonResult<NcpJjkcInvoiceTaskResult.NcpKcTaskResult> jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
            log.debug("<<<<<< \u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u83b7\u53d6 result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u83b7\u53d6\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            NcpJjkcInvoiceTaskResult ncpJjkcInvoiceTaskResult = (NcpJjkcInvoiceTaskResult)JSON.parseObject((String)data, NcpJjkcInvoiceTaskResult.class);
            if (ncpJjkcInvoiceTaskResult.isOK() && null != ncpJjkcInvoiceTaskResult.getResult()) {
                jsonResult = JsonResult.ok(ncpJjkcInvoiceTaskResult.getMessage());
                jsonResult.setData(ncpJjkcInvoiceTaskResult.getResult());
                return jsonResult;
            }
            return JsonResult.error(ncpJjkcInvoiceTaskResult.getCode(), ncpJjkcInvoiceTaskResult.getMessage());
        }
        catch (Exception e) {
            log.error("\u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u83b7\u53d6\u7ed3\u679c request error ", (Throwable)e);
            this.alerter.alert("\u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u83b7\u53d6\u7ed3\u679c\u5931\u8d25", e);
            return JsonResult.error(e.getMessage());
        }
    }

    private Tuple2<Boolean, String> checkJjkcInvoiceRequest(NcpJjkcInvoiceResquestDto ncpJjkcInvoiceResquest) {
        if (Objects.isNull(ncpJjkcInvoiceResquest)) {
            return Tuple.of((Object)true, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ncpJjkcInvoiceResquest.getTaxNo())) {
            return Tuple.of((Object)true, (Object)"\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ncpJjkcInvoiceResquest.getInvoiceNo())) {
            return Tuple.of((Object)true, (Object)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ncpJjkcInvoiceResquest.getIsCheck())) {
            return Tuple.of((Object)true, (Object)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == NcpIsCheckEnum.getByCode(ncpJjkcInvoiceResquest.getIsCheck())) {
            return Tuple.of((Object)true, (Object)"\u52fe\u9009\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ncpJjkcInvoiceResquest.getInvoiceNo())) {
            return Tuple.of((Object)true, (Object)"\u52fe\u9009\u7c7b\u578b\u9519\u8bef");
        }
        if (StringUtils.equals((CharSequence)NcpIsCheckEnum.CHECK.getCode(), (CharSequence)ncpJjkcInvoiceResquest.getIsCheck())) {
            if (StringUtils.isBlank((CharSequence)ncpJjkcInvoiceResquest.getAuthUse())) {
                return Tuple.of((Object)true, (Object)"\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == NcpAuthUseEnum.getByCode(ncpJjkcInvoiceResquest.getAuthUse())) {
                return Tuple.of((Object)true, (Object)"\u52fe\u9009\u7c7b\u578b\u9519\u8bef");
            }
        }
        if (StringUtils.equals((CharSequence)NcpIsCheckEnum.CHECK.getCode(), (CharSequence)ncpJjkcInvoiceResquest.getIsCheck()) && StringUtils.equals((CharSequence)NcpAuthUseEnum.AUTH_USE_ENUM_3.getCode(), (CharSequence)ncpJjkcInvoiceResquest.getAuthUse()) && null == ncpJjkcInvoiceResquest.getAmount()) {
            return Tuple.of((Object)true, (Object)"\u7528\u4e8e\u52a0\u8ba1\u6263\u9664\u52fe\u9009\u65f6\u672c\u6b21\u52a0\u8ba1\u6263\u9664\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Tuple.of((Object)false, (Object)"");
    }

    private Tuple2<Boolean, String> checkUseInvoiceRequest(NcpUseInvoiceRequestDto ncpUseInvoiceResquest) {
        if (Objects.isNull(ncpUseInvoiceResquest)) {
            return Tuple.of((Object)true, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ncpUseInvoiceResquest.getTaxNo())) {
            return Tuple.of((Object)true, (Object)"\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ncpUseInvoiceResquest.getInvoiceNo())) {
            return Tuple.of((Object)true, (Object)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ncpUseInvoiceResquest.getNcpType())) {
            return Tuple.of((Object)true, (Object)"\u519c\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == NcpTypeEnum.getByCode(ncpUseInvoiceResquest.getNcpType())) {
            return Tuple.of((Object)true, (Object)"\u519c\u4ea7\u54c1\u7c7b\u578b\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)ncpUseInvoiceResquest.getHandleType())) {
            return Tuple.of((Object)true, (Object)"\u519c\u4ea7\u54c1\u5904\u7406\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == NcpHandleTypeEnum.getByCode(ncpUseInvoiceResquest.getHandleType())) {
            return Tuple.of((Object)true, (Object)"\u519c\u4ea7\u54c1\u5904\u7406\u7c7b\u578b\u9519\u8bef");
        }
        if (!NcpHandleTypeEnum.check(ncpUseInvoiceResquest.getNcpType(), ncpUseInvoiceResquest.getHandleType()).booleanValue()) {
            return Tuple.of((Object)true, (Object)"\u5904\u7406\u7c7b\u578b\u4e0e\u519c\u4ea7\u54c1\u7c7b\u578b\u4e0d\u5bf9\u5e94");
        }
        if (StringUtils.equals((CharSequence)NcpTypeEnum.SELF_NCP.getCode(), (CharSequence)ncpUseInvoiceResquest.getNcpType()) && StringUtils.equals((CharSequence)NcpHandleTypeEnum.NCP_HANDLE_TYPE_5.getCode(), (CharSequence)ncpUseInvoiceResquest.getHandleType()) && null == ncpUseInvoiceResquest.getAmount()) {
            return Tuple.of((Object)true, (Object)"\u519c\u4ea7\u54c1\u90e8\u5206\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Tuple.of((Object)false, (Object)"");
    }
}

