/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.nationalTaxEntry.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.configuration.ProfileConfig;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.nationalTaxEntry.NationalTaxEntryQuery;
import com.xforceplus.evat.common.domain.nationalTaxEntry.NationalTaxEntryResult;
import com.xforceplus.evat.common.domain.nationalTaxEntry.NationalTaxEntryTaskResult;
import com.xforceplus.evat.common.modules.nationalTaxEntry.NationalTaxEntryService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NationalTaxEntryServiceImpl
implements NationalTaxEntryService {
    private static final Logger log = LoggerFactory.getLogger(NationalTaxEntryServiceImpl.class);
    @Autowired
    private ProfileConfig profileConfig;
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult invoiceEntryDeal(NationalTaxEntryQuery nationalTaxEntryQuery) {
        if (!this.profileConfig.isProfileActive("prod") && StringUtils.isEmpty((CharSequence)nationalTaxEntryQuery.getDebug())) {
            nationalTaxEntryQuery.setDebug("1");
        }
        log.debug(">>>>>> \u56fd\u7a0e\u5165\u8d26\u8bf7\u6c42 upload info = {}", (Object)JacksonUtil.getInstance().toJson((Object)nationalTaxEntryQuery));
        try {
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            JanusRequest janusRequest = JanusRequest.builder().build();
            String payLoadId = nationalTaxEntryQuery.getInvoiceNo();
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            janusRequest.setPayLoadId(payLoadId);
            janusRequest.setAction(this.janusActionConfig.getNationalTaxEntry());
            janusRequest.setData(JSONObject.toJSONString((Object)nationalTaxEntryQuery));
            janusRequest.setHeader(heaserMap);
            janusRequest.setDataType("JSON");
            JsonResult<NationalTaxEntryResult.Result> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< \u56fd\u7a0e\u5165\u8d26\u8bf7\u6c42 result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u56fd\u7a0e\u5165\u8d26\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            NationalTaxEntryResult nationalTaxEntryResult = (NationalTaxEntryResult)JSON.parseObject((String)data, NationalTaxEntryResult.class);
            if (!nationalTaxEntryResult.isOK()) {
                if (null != nationalTaxEntryResult.getResult() && ObjectUtils.isNotEmpty(nationalTaxEntryResult.getResult().getFailResult())) {
                    return JsonResult.error(nationalTaxEntryResult.getCode(), JSONObject.toJSONString(nationalTaxEntryResult.getResult().getFailResult()));
                }
                return JsonResult.error(nationalTaxEntryResult.getCode(), nationalTaxEntryResult.getMessage());
            }
            jsonResult = JsonResult.ok(nationalTaxEntryResult.getMessage());
            jsonResult.setData(nationalTaxEntryResult.getResult());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u56fd\u7a0e\u5165\u8d26\u8bf7\u6c42 request error ", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult invEntryResultDeal(String taskId) {
        log.debug(">>>>>> \u56fd\u7a0e\u5165\u8d26\u83b7\u53d6\u7ed3\u679c upload info = {}", (Object)taskId);
        try {
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            JanusRequest janusRequest = JanusRequest.builder().build();
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("taskId", taskId);
            janusRequest.setPayLoadId(taskId);
            janusRequest.setAction(this.janusActionConfig.getNationalTaxEntryTask());
            janusRequest.setTenantId(this.janusConfig.getTenantCode());
            janusRequest.setHeader(heaserMap);
            janusRequest.setIsValid(0);
            janusRequest.setData(taskId);
            JsonResult<NationalTaxEntryTaskResult.Result> jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
            log.debug("<<<<<< \u56fd\u7a0e\u5165\u8d26\u83b7\u53d6\u7ed3\u679c result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u56fd\u7a0e\u5165\u8d26\u83b7\u53d6\u7ed3\u679c\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            NationalTaxEntryTaskResult taskResult = (NationalTaxEntryTaskResult)JSON.parseObject((String)data, NationalTaxEntryTaskResult.class);
            if (!taskResult.isOK()) {
                return JsonResult.error(taskResult.getCode(), taskResult.getMessage());
            }
            jsonResult = JsonResult.ok(taskResult.getMessage());
            jsonResult.setData(taskResult.getResult());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u56fd\u7a0e\u5165\u8d26\u83b7\u53d6\u7ed3\u679c request error ", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }
}

