/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.alerter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.evat.common.alerter.Alerter;
import com.xforceplus.evat.common.alerter.AlerterConfig;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.common.utils.DateUtils;
import com.xforceplus.evat.common.utils.SpringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"qa", "uat", "prod"})
public class FeiShuAlerter
implements Alerter {
    private static final Logger log = LoggerFactory.getLogger(FeiShuAlerter.class);
    private final AlerterConfig config;
    @Value(value="${spring.application.name:wapp}")
    private String appName;
    @Value(value="#{'${alerter.ignore.error:null}'.split('<split>')}")
    private List<String> ignoreErrors;
    private static final String TEXT_TEMPLATE = "[%s]%s\n%s\n%s";

    @Override
    public void alert(String title) {
        this.alert(title, "", null);
    }

    @Override
    public void alert(String title, String content) {
        this.alert(title, content, null);
    }

    @Override
    public void alert(String title, String content, Exception exception) {
        if (this.config.isEnabled() && !CommonUtils.isCustomException(exception) && !this.ignoreErrors.contains(title)) {
            String requestBody = this.buildRequestBody(title, content, exception);
            this.send(requestBody);
        } else {
            log.info("\u544a\u8b66\u4e0d\u63a8\u9001\u3010{}\u3011", (Object)title);
        }
    }

    @Override
    public void alert(Exception exception) {
        this.alert("", "", exception);
    }

    @Override
    public void alert(String title, Exception exception) {
        this.alert(title, "", exception);
    }

    private String buildRequestBody(String title, String content, Exception exception) {
        String hostname = this.obtainHostname();
        String[] hostnames = hostname.split("/");
        hostname = hostnames.length > 1 ? hostnames[1] : hostname;
        String stacktrace = this.obtainStacktrace(exception);
        String profiles = SpringUtils.getProfiles();
        String text = String.format(TEXT_TEMPLATE, this.appName + "-" + profiles, title, content, stacktrace);
        JSONObject body = new JSONObject();
        body.put("eventname", (Object)(this.config.getPrefix() + text));
        body.put("hostname", (Object)hostname);
        body.put("eventdate", (Object)DateUtils.format(new Date(), "yyyy-MM-dd"));
        body.put("eventime", (Object)DateUtils.format(new Date(), "HH:mm:ss"));
        body.put("severity", (Object)"High");
        body.put("status", (Object)"siren");
        return body.toJSONString();
    }

    private void send(String requestBody) {
        log.info("\u5f00\u59cb\u53d1\u9001\u98de\u4e66\u544a\u8b66\u63d0\u793a");
        HttpPost httpPost = new HttpPost(this.config.getWebhookApi());
        httpPost.setHeader("Content-Type", "application/json;charset=utf8");
        StringEntity entity = new StringEntity(requestBody, "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        log.info("\u98de\u4e66\u544a\u8b66\u53d1\u9001\u5185\u5bb9\uff1a{}", (Object)requestBody);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            log.info("alert response status = " + response.getStatusLine());
            HttpEntity responseEntity = response.getEntity();
            if (Objects.nonNull(responseEntity)) {
                log.info("alert response length = {}, alert response = {}", (Object)responseEntity.getContentLength(), (Object)EntityUtils.toString((HttpEntity)responseEntity));
            }
        }
        catch (Exception e) {
            log.error("\u98de\u4e66\u544a\u8b66\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            String hostname = InetAddress.getLocalHost().toString();
            String[] hostnames = hostname.split("/");
            System.out.println(JSON.toJSONString((Object)(hostnames.length > 1 ? hostnames[1] : hostname)));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public FeiShuAlerter(AlerterConfig config) {
        this.config = config;
    }
}

