/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.evat.common.constant.consist.GlobalConstants;
import com.xforceplus.evat.common.constant.enums.InvoiceTypeEnum;
import io.vavr.Tuple;
import io.vavr.Tuple4;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtils.class);
    private static final DecimalFormat DECIMAL_RATIO_FORMAT = new DecimalFormat("0%");
    private static String[] fpdmlist = new String[]{"144031539110", "131001570151", "133011501118", "111001571071"};

    public static String getFplx(String fpdm) {
        String fplx = "";
        if (StringUtils.isBlank((CharSequence)fpdm)) {
            return fplx;
        }
        if (fpdm.trim().length() == 12) {
            String fplxflag = fpdm.substring(7, 8);
            for (int i = 0; i < fpdmlist.length; ++i) {
                if (!fpdm.equals(fpdmlist[i])) continue;
                fplx = InvoiceTypeEnum.E_INVOICE.getResultCode();
                break;
            }
            if ("0".equals(fpdm.substring(0, 1)) && "11".equals(fpdm.substring(10, 12))) {
                fplx = InvoiceTypeEnum.E_INVOICE.getResultCode();
            }
            if ("0".equals(fpdm.substring(0, 1)) && "12".equals(fpdm.substring(10, 12))) {
                fplx = InvoiceTypeEnum.TOLLS_INVOICE.getResultCode();
            }
            if ("0".equals(fpdm.substring(0, 1)) && ("06".equals(fpdm.substring(10, 12)) || "07".equals(fpdm.substring(10, 12)))) {
                fplx = InvoiceTypeEnum.VOLUME_INVOICE.getResultCode();
            }
            if ("2".equals(fplxflag) && !"0".equals(fpdm.substring(0, 1))) {
                fplx = InvoiceTypeEnum.MOTOR_INVOICE.getResultCode();
            }
            if ("0".equals(fpdm.substring(0, 1)) && ("04".equals(fpdm.substring(10, 12)) || "05".equals(fpdm.substring(10, 12)))) {
                fplx = InvoiceTypeEnum.GENERAL_INVOICE.getResultCode();
            }
        } else if (fpdm.trim().length() == 10) {
            String fplxflag = fpdm.substring(7, 8);
            if ("1".equals(fplxflag) || "5".equals(fplxflag)) {
                fplx = InvoiceTypeEnum.SPECIAL_INVOICE.getResultCode();
            } else if ("6".equals(fplxflag) || "3".equals(fplxflag)) {
                fplx = InvoiceTypeEnum.GENERAL_INVOICE.getResultCode();
            } else if ("7".equals(fplxflag) || "2".equals(fplxflag)) {
                fplx = InvoiceTypeEnum.MOTOR_INVOICE_02.getResultCode();
            }
        }
        return fplx;
    }

    public static String formatMoney(Double value) {
        String valueStr;
        int index;
        if (value == null) {
            return "";
        }
        Boolean isMinus = false;
        if (value < 0.0) {
            value = -value.doubleValue();
            isMinus = true;
        }
        if ((index = (valueStr = String.valueOf(value)).indexOf(".")) < 0) {
            valueStr = valueStr + ".00";
        }
        if (valueStr.length() == index + 2) {
            valueStr = valueStr + "0";
        }
        index = valueStr.indexOf(46);
        while (index - 3 > 0) {
            valueStr = valueStr.substring(0, index - 3) + "," + valueStr.substring(index - 3);
            index -= 3;
        }
        return isMinus != false ? "-" + valueStr : valueStr;
    }

    public static Boolean isValidDate(String str, String formatter, String regex) {
        Pattern pattern;
        Matcher m;
        Boolean dateFlag;
        Boolean flag = Boolean.FALSE;
        if (!StringUtils.isEmpty((CharSequence)regex) && !(dateFlag = Boolean.valueOf((m = (pattern = Pattern.compile(regex)).matcher(str)).matches())).booleanValue()) {
            return Boolean.FALSE;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatter);
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(str);
            flag = Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.info("str:{},formatter:{}, regex:{} \u65f6\u95f4\u683c\u5f0f\u9519\u8bef:{}", (Throwable)e);
        }
        return flag;
    }

    public static Boolean isValidNum(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(str);
        return m.matches();
    }

    public static String gzip(byte[] file) {
        String base64Str = Base64.encodeBase64String((byte[])Objects.requireNonNull(file));
        return CommonUtils.gzip(base64Str);
    }

    public static String gzip(String fileBase64) {
        GZIPOutputStream gzip = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            gzip.write(fileBase64.getBytes());
            gzip.close();
            return Base64.encodeBase64String((byte[])Objects.requireNonNull(out.toByteArray()));
        }
        catch (Exception e) {
            log.error("\u5b57\u7b26\u4e32\u538b\u7f29\u5f02\u5e38:", (Throwable)e);
            return "";
        }
    }

    public static String uncompress(String gzipBase64) {
        if (StringUtils.isBlank((CharSequence)gzipBase64)) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((byte[])gzipBase64.getBytes()));
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            log.error("\u5b57\u7b26\u4e32\u89e3\u538b\u7f29\u5f02\u5e38:", (Throwable)e);
        }
        return Base64.encodeBase64String((byte[])out.toByteArray());
    }

    public static String genUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String strSecurityFilter(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("../", "").replaceAll("..\\\\", "").replaceAll("\\*", "");
    }

    public static Optional<BigDecimal> taxRateHandle(String taxRateStr) {
        if (StringUtils.isBlank((CharSequence)taxRateStr)) {
            return Optional.empty();
        }
        try {
            taxRateStr = StringUtils.replace((String)taxRateStr, (String)"%", (String)"");
            BigDecimal taxRate = new BigDecimal(taxRateStr);
            if (BigDecimal.ONE.compareTo(taxRate) > 0) {
                taxRate = taxRate.movePointRight(2);
            }
            return Optional.of(taxRate);
        }
        catch (Exception e) {
            log.error("error={}", (Object)e.getMessage());
            return Optional.of(BigDecimal.ZERO);
        }
    }

    public static Optional<String> taxRateRatio(BigDecimal taxRate) {
        if (taxRate == null) {
            return Optional.empty();
        }
        try {
            if (BigDecimal.ONE.compareTo(taxRate) < 0) {
                taxRate = taxRate.movePointLeft(2);
            }
            return Optional.of(DECIMAL_RATIO_FORMAT.format(taxRate));
        }
        catch (Exception e) {
            log.error("error={}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static Optional<String> taxRateToInt(BigDecimal taxRate) {
        if (taxRate == null) {
            return Optional.empty();
        }
        try {
            if (BigDecimal.ONE.compareTo(taxRate) > 0) {
                taxRate = taxRate.movePointRight(2);
            }
            return Optional.of(taxRate.toPlainString());
        }
        catch (Exception e) {
            log.error("error={}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static String amountToStr(BigDecimal bigDecimal) {
        return CommonUtils.amountToStr(bigDecimal, 2);
    }

    public static String amountToStr(BigDecimal bigDecimal, int newScale) {
        return Optional.ofNullable(bigDecimal).map(s -> bigDecimal.setScale(newScale, RoundingMode.HALF_UP).toPlainString()).orElse("");
    }

    public static Boolean isQuanDian(String invoiceNo) {
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            return false;
        }
        boolean isHostVirtual = GlobalConstants.HOST_VIRTUAL_PREFIX.stream().anyMatch(invoiceNo::startsWith);
        if (isHostVirtual) {
            return false;
        }
        if (invoiceNo.length() == 20 && !StringUtils.equals((CharSequence)invoiceNo.substring(0, 7), (CharSequence)"0000000")) {
            return true;
        }
        return false;
    }

    public static Optional<String> getHostInvWeb(String hostInvNo) {
        if (StringUtils.isBlank((CharSequence)hostInvNo)) {
            return Optional.empty();
        }
        String prefix = hostInvNo.substring(0, 7);
        if (hostInvNo.length() > 14 && !StringUtils.equals((CharSequence)prefix, (CharSequence)"0000000")) {
            String hostInv = hostInvNo.substring(1, 15);
            log.info("HOST\u7cfb\u7edf\u53d1\u7968\u53f7\u7801:{} to hostInv:{}", (Object)hostInvNo, (Object)hostInv);
            return Optional.of(hostInv);
        }
        return Optional.empty();
    }

    public static Optional<String> getHostInv(String hostInvNo) {
        if (StringUtils.isBlank((CharSequence)hostInvNo)) {
            return Optional.empty();
        }
        int length = StringUtils.length((CharSequence)hostInvNo);
        if (length == 20 && !hostInvNo.startsWith("0")) {
            return Optional.of(hostInvNo);
        }
        if (hostInvNo.startsWith("000000000000")) {
            return Optional.of(hostInvNo.substring(length - 8, length));
        }
        if (hostInvNo.startsWith("000000")) {
            return Optional.of(hostInvNo.substring(length - 14, length));
        }
        if (hostInvNo.startsWith("00000")) {
            return Optional.of(hostInvNo.substring(length - 15, length));
        }
        return Optional.empty();
    }

    public static String getGoodsName(String goodsName) {
        if (StringUtils.isBlank((CharSequence)goodsName)) {
            return "";
        }
        String regEx = "^\\*[\\s\\S]{1,99}\\*[\\s\\S]{1,99}$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(goodsName);
        if (matcher.matches()) {
            goodsName = goodsName.substring(goodsName.indexOf("*", goodsName.indexOf("*") + 1) + 1);
        }
        return goodsName;
    }

    public static BigDecimal toBigDecimal(String str, BigDecimal defaultValue) {
        try {
            str = CommonUtils.removeThousandsSeparator(str);
            return NumberUtils.createBigDecimal((String)str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static String removeThousandsSeparator(String formattedAmount) throws ParseException {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = numberFormat.parse(formattedAmount);
        return number.toString();
    }

    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) {
        if (map == null) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object obj = objectMapper.convertValue(map, beanClass);
        return obj;
    }

    public static String getLargeCategory(String detailGoodsName) {
        if (StringUtils.isEmpty((CharSequence)detailGoodsName)) {
            return "";
        }
        Pattern pattern = Pattern.compile("(?<=\\*)[^*]*(?=\\*)");
        Matcher matcher = pattern.matcher(detailGoodsName);
        while (matcher.find()) {
            if (!StringUtils.isNotEmpty((CharSequence)matcher.group())) continue;
            return matcher.group();
        }
        return "";
    }

    public static String getHexMD5Str(String str) {
        return MD5Util.getHexMD5Str((String)str, (int)16);
    }

    public static Tuple4<String, String, String, String> splitGoodsNameAndSign(String detailGoodsName) {
        String largeCategory = CommonUtils.getLargeCategory(detailGoodsName);
        String goodsName = CommonUtils.getGoodsName(detailGoodsName);
        return Tuple.of((Object)largeCategory, (Object)CommonUtils.getHexMD5Str(largeCategory), (Object)goodsName, (Object)CommonUtils.getHexMD5Str(goodsName));
    }

    public static boolean isCustomException(Exception e) {
        List<String> exceptionClasses = Arrays.asList("NoSuchInvoiceException", "EnhanceRuntimeException", "RRException");
        return exceptionClasses.stream().anyMatch(exceptionClass -> e != null && exceptionClass.equals(e.getClass().getSimpleName()));
    }

    public static boolean startWith(String goodsName, String prefix) {
        boolean isExists = false;
        String[] goodsNames = goodsName.split("\\*");
        List goodsNameList = Arrays.stream(goodsNames).filter(item -> StringUtils.isNotEmpty((CharSequence)item)).collect(Collectors.toList());
        for (int i = 0; i < goodsNameList.size(); ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)goodsNameList.get(i))) || i + 1 >= goodsNameList.size() || !StringUtils.startsWithIgnoreCase((CharSequence)((CharSequence)goodsNameList.get(i + 1)), (CharSequence)prefix)) continue;
            isExists = true;
        }
        return isExists;
    }
}

