/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATEPATTERN_TIME = "yyyyMMdd";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_PATTERN_OTHER = "yyyy/MM/dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_PATTERN_NUM = "yyyyMMddHHmmssSSS";
    public static final String DATE_TIME_SSS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_TIME_SSSZ_PATTERN = "yyyy-MM-dd'T'hh:mm:ss.SSSZ";
    public static final String DATE_TIME_GMT_PATTERN = "EEE MMM dd HH:mm:ss 'GMT' yyyy";
    public static final String DATE_TIME_CST_PATTERN = "EEE MMM dd HH:mm:ss 'CST' yyyy";
    public static final ThreadLocal<SimpleDateFormat> DATE_TIME_SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_PATTERN));
    public static final ThreadLocal<SimpleDateFormat> DATE_TIME_SSS_SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_SSS_PATTERN));
    public static final ThreadLocal<SimpleDateFormat> DATE_TIME_SSSZ_SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_SSSZ_PATTERN));
    public static final ThreadLocal<SimpleDateFormat> DATE_TIME_GMT_SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_GMT_PATTERN, Locale.US));
    public static final ThreadLocal<SimpleDateFormat> DATE_TIME_CST_SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_CST_PATTERN, Locale.US));

    public static String format() {
        return DateUtils.format(DATE_TIME_PATTERN);
    }

    public static String format(String pattern) {
        return DateUtils.format(LocalDateTime.now(), pattern);
    }

    public static String format(LocalDateTime localDateTime) {
        return DateUtils.format(localDateTime, DATE_TIME_PATTERN);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(LocalDate localDate) {
        return DateUtils.format(localDate, DATE_PATTERN);
    }

    public static String format(LocalDate localDate, String pattern) {
        return localDate.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(LocalTime localTime) {
        return DateUtils.format(localTime, TIME_PATTERN);
    }

    public static String format(LocalTime localTime, String pattern) {
        return localTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(Date date) {
        return DateUtils.format(date, DATE_TIME_PATTERN);
    }

    public static String format(Date date, String pattern) {
        return DateUtils.format(DateUtils.toLocalDateTime(date), pattern);
    }

    public static String formatNowDate(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(new Date());
    }

    public static final String convertForDate(String strDate, String oPattern, String nPattern) {
        return DateUtils.format(DateUtils.toLocalDate(strDate, oPattern), nPattern);
    }

    public static final String convertForDateTime(String strDate, String oPattern, String nPattern) {
        return DateUtils.format(DateUtils.toLocalDateTime(strDate, oPattern), nPattern);
    }

    public static String format(long epochMilli) {
        return DateUtils.format(DateUtils.toLocalDateTime(epochMilli));
    }

    public static String format(long epochMilli, String pattern) {
        return DateUtils.format(DateUtils.toLocalDateTime(epochMilli), pattern);
    }

    public static String format(String epochMilli, String pattern) {
        return DateUtils.format(Long.parseLong(epochMilli), pattern);
    }

    public static long toEpochMilli() {
        return DateUtils.toEpochMilli(LocalDateTime.now());
    }

    public static long toEpochMilli(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toEpochMilli(String dateText, String pattern) {
        return DateUtils.toEpochMilli(DateUtils.toLocalDateTime(dateText, pattern));
    }

    public static long toEpochMilli(String dateText) {
        return DateUtils.toEpochMilli(dateText, DATE_TIME_PATTERN);
    }

    public static LocalDateTime toLocalDateTime(long epochMilli) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(String dateText, String pattern) {
        return LocalDateTime.parse(dateText, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate toLocalDate(Date date) {
        return DateUtils.toLocalDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(String dateText) {
        String pattern;
        block0 : switch (dateText.length()) {
            case 8: {
                pattern = DATEPATTERN_TIME;
                break;
            }
            case 10: {
                switch (dateText.charAt(4)) {
                    case '-': {
                        pattern = DATE_PATTERN;
                        break block0;
                    }
                    case '/': {
                        pattern = DATE_PATTERN_OTHER;
                        break block0;
                    }
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return DateUtils.toLocalDate(dateText, pattern);
    }

    public static LocalDate toLocalDate(String dateText, String pattern) {
        return LocalDate.parse(dateText, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime toLocalTime(Date date) {
        return DateUtils.toLocalDateTime(date).toLocalTime();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate, LocalTime localTime) {
        return DateUtils.toDate(LocalDateTime.of(localDate, localTime));
    }

    public static LocalDateTime toLocalDateTime(String text) {
        return DateUtils.toJavaDate(text).map(DateUtils::toLocalDateTime).orElse(null);
    }

    public static Optional<Date> toJavaDate(String text) {
        try {
            if (StringUtils.isBlank((CharSequence)text)) {
                return Optional.empty();
            }
            if (NumberUtils.isDigits((String)text)) {
                return Optional.of(Date.from(Instant.ofEpochMilli(Long.parseLong(text))));
            }
            if (text.contains("CST")) {
                return Optional.of(DATE_TIME_CST_SDF.get().parse(text));
            }
            if (text.contains("GMT")) {
                return Optional.of(DATE_TIME_GMT_SDF.get().parse(text));
            }
            if (text.length() == "2020-07-27T16:08:49.340+0000".length()) {
                return Optional.of(DATE_TIME_SSSZ_SDF.get().parse(text));
            }
            if (text.contains("AM") || text.contains("PM")) {
                return Optional.of(new SimpleDateFormat("M/d/yy h:m a", Locale.US).parse(text));
            }
            if (text.length() == DATE_TIME_SSS_PATTERN.length()) {
                return Optional.of(DATE_TIME_SSS_SDF.get().parse(text));
            }
            if (text.length() == DATE_TIME_PATTERN.length()) {
                return Optional.of(DATE_TIME_SDF.get().parse(text));
            }
        }
        catch (ParseException e) {
            log.warn("Date parse fail- {}", (Object)text, (Object)e);
        }
        return Optional.empty();
    }

    public static LocalDate adjustTemporal(LocalDate localDate, TemporalAdjuster ... adjuster) {
        LocalDate newLocalDate = localDate;
        for (TemporalAdjuster temporalAdjuster : adjuster) {
            newLocalDate = newLocalDate.with(temporalAdjuster);
        }
        return newLocalDate;
    }

    public static boolean isSameDay(LocalDate localDate, TemporalAdjuster ... adjuster) {
        return localDate.equals(DateUtils.adjustTemporal(localDate, adjuster));
    }

    public static boolean sleep(long timeout) {
        boolean interrupted = false;
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        return interrupted;
    }

    public static Date convertStringToDate(String strDate) {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(DATEPATTERN_TIME);
        try {
            date = df.parse(strDate);
            return date;
        }
        catch (ParseException var5) {
            log.error(var5.getMessage());
            return date;
        }
    }

    public static Date convertStringToDate(String strDate, String pattern) {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            date = df.parse(strDate);
            return date;
        }
        catch (ParseException var5) {
            log.error(var5.getMessage());
            return date;
        }
    }

    public static Date convertStringToDateHourMin(String strDate) {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_PATTERN);
        try {
            date = df.parse(strDate);
            return date;
        }
        catch (ParseException var5) {
            log.error(var5.getMessage());
            return date;
        }
    }

    public static long getDays(Date date1, Date date2) {
        Long day = -1L;
        if (ObjectUtils.isNotEmpty((Object)date1) && ObjectUtils.isNotEmpty((Object)date2)) {
            day = (date1.getTime() - date2.getTime()) / 86400000L;
        }
        return day;
    }

    public static String getLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        String lastMonth = dateFormat.format(calendar.getTime());
        return lastMonth;
    }

    public static String dateAddDay(Date date, Integer day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEPATTERN_TIME);
        String lastMonth = dateFormat.format(calendar.getTime());
        return lastMonth;
    }

    public static Long getDayOfMonthFirst(String timeStr) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
            Date date = format.parse(timeStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(5, 1);
            Date firstDayOfMonth = calendar.getTime();
            return firstDayOfMonth.getTime();
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5f53\u524d\u6708\u7b2c\u4e00\u5929\u65f6\u95f4\u6233\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static Long getDayOfMonthLast(String timeStr) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
            Date date = format.parse(timeStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(5, calendar.getActualMaximum(5));
            Date lastDayOfMonth = calendar.getTime();
            return lastDayOfMonth.getTime();
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5f53\u524d\u6708\u7b2c\u4e00\u5929\u65f6\u95f4\u6233\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static String strToStr(String strDate, String strDateFormat, String resultForMat) {
        SimpleDateFormat sdf1 = new SimpleDateFormat(strDateFormat);
        SimpleDateFormat sdf2 = new SimpleDateFormat(resultForMat);
        try {
            Date date = sdf1.parse(strDate);
            String str = sdf2.format(date);
            return str;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate(String strDate) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        try {
            String pattern;
            switch (strDate.length()) {
                case 8: {
                    pattern = DATEPATTERN_TIME;
                    break;
                }
                case 10: {
                    if (strDate.contains("-")) {
                        pattern = DATE_PATTERN;
                        break;
                    }
                    pattern = DATE_PATTERN_OTHER;
                    break;
                }
                case 16: {
                    pattern = "yyyyMMddHHmmss";
                    break;
                }
                case 19: {
                    pattern = DATE_TIME_PATTERN;
                    break;
                }
                default: {
                    pattern = DATE_TIME_PATTERN;
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            Date date = sdf.parse(strDate);
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date obtainValidDate(Date srcDate) {
        return srcDate == null ? null : new Date(srcDate.getTime());
    }
}

