/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    protected static Logger log = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String path, String fileName, String fileContent) throws IOException {
        if (null == fileContent || "".equals(fileContent)) {
            return;
        }
        if (!FileUtil.directoryIsExists(path)) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(new File(path + fileName));
            writer.write(fileContent);
            writer.flush();
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean directoryIsExists(String path) {
        File directory = new File(path);
        if (directory.exists()) {
            return true;
        }
        if (!directory.mkdir()) {
            return false;
        }
        if (directory.canWrite()) {
            return true;
        }
        return directory.setWritable(true);
    }

    public static boolean deleteFolder(String sPath) {
        if (StringUtils.isBlank((CharSequence)sPath)) {
            return false;
        }
        File file = new File(sPath);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return FileUtil.deleteFile(sPath);
        }
        return FileUtil.deleteDirectory(sPath);
    }

    public static boolean deleteFile(String sPath) {
        if (StringUtils.isBlank((CharSequence)sPath)) {
            return false;
        }
        File file = new File(sPath);
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        File[] files = dirFile.listFiles();
        boolean flag = true;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                if (FileUtil.deleteFile(files[i].getAbsolutePath())) continue;
                flag = false;
                break;
            }
            if (FileUtil.deleteDirectory(files[i].getAbsolutePath())) continue;
            flag = false;
            break;
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }
}

