/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringUtils.class);
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static <T> T getBean(Class<T> beanClass) {
        return (T)context.getBean(beanClass);
    }

    public static Object getBean(String beanName) {
        return context.getBean(beanName);
    }

    public static String getAppName() {
        return context.getEnvironment().getProperty("spring.application.name");
    }

    public static String getProfiles() {
        return context.getEnvironment().getProperty("spring.profiles.active");
    }
}

