/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.ftp;

import cn.hutool.core.io.IoUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.xforceplus.evat.common.alerter.Alerter;
import com.xforceplus.evat.common.constant.consist.FtpConfigProperties;
import com.xforceplus.evat.common.utils.SpringUtils;
import com.xforceplus.evat.common.utils.TraceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FtpService {
    private static final Logger log = LoggerFactory.getLogger(FtpService.class);
    private static final String IDENTITY_NAME = "sftp-private-key";
    public static final String AUTH_METHOD_PWD = "pwd";
    public static final String AUTH_METHOD_PRI = "private";
    private ChannelSftp sftp = null;
    private Session session = null;
    private Channel channel = null;
    @Autowired
    private FtpConfigProperties ftpConfigProperties;
    public static byte[] privateKeyByte = new byte[0];

    @PostConstruct
    private void init() {
        try {
            log.info("\u521d\u59cb\u5316FTP\u8bc1\u4e66\u79d8\u94a5\u6587\u4ef6\uff0cprivate-key-config:{},key-path:{}", (Object)this.ftpConfigProperties.getAuthMethod(), (Object)this.ftpConfigProperties.getPrivateKey());
            if (Objects.equals(this.ftpConfigProperties.getAuthMethod(), AUTH_METHOD_PWD) || StringUtils.isBlank((CharSequence)this.ftpConfigProperties.getPrivateKey())) {
                log.info("FTP\u914d\u7f6e\u975e\u79c1\u94a5\u8ba4\u8bc1\u65b9\u5f0f\u6216\u672a\u914d\u7f6e\u79c1\u94a5\u5730\u5740\uff0c\u4e0d\u521d\u59cb\u5316\u8bc1\u4e66\u79d8\u94a5\u6587\u4ef6\u3002");
                return;
            }
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            InputStream inputStream = resourceLoader.getResource(this.ftpConfigProperties.getPrivateKey()).getInputStream();
            privateKeyByte = IOUtils.toByteArray((InputStream)inputStream);
            if (privateKeyByte == null || privateKeyByte.length < 1) {
                throw new RuntimeException("\u521d\u59cb\u5316FTP\u8bc1\u4e66\u79d8\u94a5\u6587\u4ef6\u5931\u8d25\u3002");
            }
            String certContent = new String(privateKeyByte, StandardCharsets.UTF_8);
            log.info("\u6210\u529f\u83b7\u53d6\u8bc1\u4e66\u6587\u4ef6,byte.size:{} , certContent={}", (Object)privateKeyByte.length, (Object)certContent);
        }
        catch (Exception e) {
            log.error("\u79c1\u94a5\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25\u3002");
            Alerter alerter = SpringUtils.getBean(Alerter.class);
            alerter.alert("sftp\u79c1\u94a5\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25", e);
            throw new RuntimeException(e);
        }
    }

    public void closeChannel() {
        if (null != this.channel) {
            this.channel.disconnect();
        }
        if (null != this.session) {
            this.session.disconnect();
        }
        if (null != this.sftp) {
            this.sftp.disconnect();
        }
    }

    private void initFtpClient() {
        try {
            this.session = FtpService.getSession(this.ftpConfigProperties);
            if (this.session == null) {
                log.error("\u83b7\u53d6SFTP Session\u4e3a\u7a7a\u3002");
                return;
            }
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
            this.sftp = (ChannelSftp)this.channel;
        }
        catch (Exception e) {
            log.error("sftp\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            Alerter alerter = SpringUtils.getBean(Alerter.class);
            alerter.alert("sftp\u64cd\u4f5c\u5f02\u5e38", e);
        }
    }

    public static synchronized Session getSession(FtpConfigProperties ftpConfigProperties) {
        try {
            log.info("ftp getSession:{}", (Object)ftpConfigProperties);
            if (ftpConfigProperties.getPort() < 0) {
                ftpConfigProperties.setPort(22);
            }
            log.info("authMethod={},private-key-config:{}", (Object)ftpConfigProperties.getAuthMethod(), (Object)ftpConfigProperties.getPrivateKey());
            JSch jsch = new JSch();
            if (Objects.equals(ftpConfigProperties.getAuthMethod(), AUTH_METHOD_PRI)) {
                if (StringUtils.isBlank((CharSequence)ftpConfigProperties.getPrivateKey())) {
                    log.error("SFTP\u914d\u7f6e\u4e3a\u79c1\u94a5\u767b\u5f55\uff0c\u5219\u9700\u8981\u914d\u7f6e\u79c1\u94a5\u5730\u5740\u3002");
                    return null;
                }
                if (privateKeyByte == null || privateKeyByte.length < 1) {
                    log.error("\u83b7\u53d6\u79c1\u94a5\u8bc1\u4e66\u6587\u4ef6\u5185\u5bb9\u5931\u8d25\u3002");
                    return null;
                }
                DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
                log.info("private-key-path={}", (Object)resourceLoader.getResource(ftpConfigProperties.getPrivateKey()).getURL());
                jsch.addIdentity(IDENTITY_NAME, privateKeyByte, null, null);
            }
            Session session = jsch.getSession(ftpConfigProperties.getUsername(), ftpConfigProperties.getHost(), ftpConfigProperties.getPort());
            if (Objects.equals(ftpConfigProperties.getAuthMethod(), AUTH_METHOD_PWD) && ftpConfigProperties.getPassword() != null) {
                log.info("\u901a\u8fc7\u5bc6\u7801\u65b9\u5f0f\u8ba4\u8bc1\uff1a{}", (Object)ftpConfigProperties.getPassword());
                session.setPassword(ftpConfigProperties.getPassword());
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            session.setConfig(config);
            session.setTimeout(Integer.parseInt(ftpConfigProperties.getTimeout()));
            session.connect();
            return session;
        }
        catch (Exception e) {
            log.info("getSession fail:privateKeyByte:{},authMethod={},Username:{},Host:{}", new Object[]{Base64.encodeBase64String((byte[])privateKeyByte), ftpConfigProperties.getAuthMethod(), ftpConfigProperties.getUsername(), ftpConfigProperties.getHost()});
            log.error("sftp \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            Alerter alerter1 = SpringUtils.getBean(Alerter.class);
            alerter1.alert("sftp \u767b\u5f55\u5f02\u5e38", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String pathname, String fileName, InputStream inputStream) throws Exception {
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6,pathName={},fileName={}", (Object)pathname, (Object)fileName);
        this.initFtpClient();
        try {
            try {
                this.sftp.cd(pathname);
            }
            catch (SftpException e) {
                String[] dirs = pathname.split("/");
                String tempPath = "";
                for (String dir : dirs) {
                    if (null == dir || "".equals(dir)) continue;
                    tempPath = tempPath + "/" + dir;
                    try {
                        this.sftp.cd(tempPath);
                    }
                    catch (SftpException ex) {
                        this.sftp.mkdir(tempPath);
                        this.sftp.cd(tempPath);
                    }
                }
            }
            this.sftp.put(inputStream, fileName);
            inputStream.close();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\u3002");
            String string = this.sftp.pwd() + fileName;
            return string;
        }
        finally {
            this.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(String pathname, String fileName, MultipartFile file) throws Exception {
        TraceUtils.setTraceId(null);
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6,pathName={},fileName={}", (Object)pathname, (Object)file.getOriginalFilename());
        this.initFtpClient();
        try {
            try {
                this.sftp.cd(pathname);
            }
            catch (SftpException e) {
                String[] dirs = pathname.split("/");
                String tempPath = "";
                for (String dir : dirs) {
                    if (null == dir || "".equals(dir)) continue;
                    tempPath = tempPath + "/" + dir;
                    try {
                        this.sftp.cd(tempPath);
                    }
                    catch (SftpException ex) {
                        this.sftp.mkdir(tempPath);
                        this.sftp.cd(tempPath);
                    }
                }
            }
            InputStream inputStream = file.getInputStream();
            this.sftp.put(file.getInputStream(), fileName);
            inputStream.close();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\u3002");
        }
        finally {
            this.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFile(String directory, String fileName) throws Exception {
        TraceUtils.setTraceId(null);
        boolean succ = false;
        try {
            log.info("\u5f00\u59cb\u5220\u9664\u6587\u4ef6\uff0cdirectory={},fileName={}", (Object)directory, (Object)fileName);
            this.initFtpClient();
            if (directory != null && !"".equals(directory)) {
                this.sftp.cd(directory);
            }
            this.sftp.rm(fileName);
            succ = true;
            log.debug("\u5220\u9664\u6587\u4ef6\u6210\u529f!");
            boolean bl = succ;
            return bl;
        }
        finally {
            this.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String directory, String downloadFile, String saveFile) throws Exception {
        TraceUtils.setTraceId(null);
        boolean succ = false;
        try {
            String file;
            File fileLocal;
            log.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6\uff0cdirectory={},downloadFile={},saveFile={}", new Object[]{directory, downloadFile, saveFile});
            File filePath = new File(saveFile);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            this.initFtpClient();
            if (directory != null && !"".equals(directory)) {
                this.sftp.cd(directory);
            }
            if ((fileLocal = new File(file = saveFile + downloadFile)).exists()) {
                fileLocal.delete();
            }
            fileLocal.createNewFile();
            this.sftp.get(downloadFile, file);
            succ = true;
            log.debug("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f!");
            boolean bl = succ;
            return bl;
        }
        finally {
            this.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileBytes(String downloadPath, String localtempPath, String saveFile) {
        TraceUtils.setTraceId(null);
        try {
            log.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6\uff0cdirectory={},saveFile={}", (Object)downloadPath, (Object)saveFile);
            this.initFtpClient();
            String[] pathArry = downloadPath.split("/");
            StringBuffer filePath = new StringBuffer("/");
            for (int i = 0; i < pathArry.length - 1; ++i) {
                if (pathArry[i].equals("")) continue;
                filePath.append(pathArry[i] + "/");
                if (this.isDirExist(filePath.toString())) {
                    this.sftp.cd(filePath.toString());
                    continue;
                }
                this.sftp.mkdir(filePath.toString());
                this.sftp.cd(filePath.toString());
            }
            File directory = new File(localtempPath);
            if (!directory.exists()) {
                if (!directory.mkdirs()) {
                    throw new FileNotFoundException();
                }
                if (!directory.canWrite() && !directory.setWritable(true)) {
                    throw new FileNotFoundException();
                }
            }
            File file = new File(localtempPath + saveFile);
            FileOutputStream out = new FileOutputStream(file);
            this.sftp.get(downloadPath, (OutputStream)out);
            if (null != out) {
                out.close();
            }
            byte[] byArray = IoUtil.readBytes((InputStream)new FileInputStream(file));
            return byArray;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.closeChannel();
        }
        return null;
    }

    public boolean isDirExist(String directory) {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = this.sftp.lstat(directory);
            isDirExistFlag = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().equals("no such file")) {
                isDirExistFlag = false;
            }
            return isDirExistFlag;
        }
    }

    @PreDestroy
    public void destroy() {
        this.closeChannel();
    }
}

