/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);

    public static String getSign(String appName, String source, String timestamp, String format, String version, String param, String appSecret) {
        param = JSON.toJSONString((Object)JSON.parseObject((String)param), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        String result = appName + source + timestamp + format + version + param;
        return SignUtils.getSignBySHA512(result, appSecret);
    }

    public static String getSignBySHA512(String param, String appSecret) {
        log.info("param:" + param);
        StringBuilder resultStr = new StringBuilder("");
        resultStr.append(appSecret).append(param).append(appSecret);
        log.info("encrypt param str:" + resultStr.toString());
        String sign = SignUtils.hashValue(resultStr.toString()).toUpperCase();
        log.info("encrypt sign:" + sign);
        return sign;
    }

    public static String hashValue(String value) {
        MessageDigest sha512 = null;
        try {
            sha512 = MessageDigest.getInstance("SHA-512");
            sha512.update(value.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            log.error("no such Algorithm:", (Throwable)e);
        }
        return SignUtils.convertByteToHex(sha512.digest());
    }

    public static String convertByteToHex(byte[] data) {
        StringBuilder hexData = new StringBuilder();
        for (int byteIndex = 0; byteIndex < data.length; ++byteIndex) {
            hexData.append(Integer.toString((data[byteIndex] & 0xFF) + 256, 16).substring(1));
        }
        return hexData.toString();
    }
}

