/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);
    protected static int k = 1;

    public static void zip(String zipFileName, File inputFile) throws Exception {
        logger.info("{}\u538b\u7f29\u4e2d...{}", (Object)zipFileName, (Object)inputFile.getCanonicalPath());
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
             BufferedOutputStream bo = new BufferedOutputStream(out);){
            ZipUtil.zip(out, inputFile, inputFile.getName(), bo);
        }
        logger.info("{}\u538b\u7f29\u5b8c\u6210{}", (Object)zipFileName, (Object)inputFile.getCanonicalPath());
    }

    public static void zipFiles(File[] srcfile, File zipfile) {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));){
            for (int i = 0; i < srcfile.length; ++i) {
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.closeEntry();
                in.close();
            }
        }
        catch (IOException e) {
            logger.debug("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a" + e);
        }
    }

    private static void zip(ZipOutputStream out, File f, String base, BufferedOutputStream bo) throws Exception {
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            if (fl.length == 0) {
                out.putNextEntry(new ZipEntry(base + "/"));
            }
            for (int i = 0; i < fl.length; ++i) {
                ZipUtil.zip(out, fl[i], base + "/" + fl[i].getName(), bo);
            }
            ++k;
        } else {
            int b;
            out.putNextEntry(new ZipEntry(base));
            FileInputStream in = new FileInputStream(f);
            BufferedInputStream bi = new BufferedInputStream(in);
            while ((b = bi.read()) != -1) {
                bo.write(b);
            }
            bi.close();
            in.close();
        }
    }

    public static byte[] readZipFile(String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new NullPointerException(filePath + "not found");
        }
        return ZipUtil.readZipFile(new FileInputStream(file));
    }

    public static byte[] readZipFile(InputStream inputStream) throws Exception {
        byte[] byteArray = null;
        try (ZipInputStream Zin = new ZipInputStream(inputStream);
             BufferedInputStream Bin = new BufferedInputStream(Zin);){
            ZipEntry entry;
            ByteArrayOutputStream bos = null;
            while ((entry = Zin.getNextEntry()) != null && !entry.isDirectory()) {
                int b;
                bos = new ByteArrayOutputStream();
                while ((b = Bin.read()) != -1) {
                    bos.write(b);
                }
            }
            byteArray = bos.toByteArray();
        }
        return byteArray;
    }

    public static byte[] readInputStream(InputStream inputStream) throws Exception {
        byte[] buffer = new byte[1024];
        int len = -1;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.close();
        inputStream.close();
        return outputStream.toByteArray();
    }
}

